proc(c)=covabrr(a,b,ew,r,j,l,di,diord)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  modelrr, covabc, covarr, covbrr
; ----------------------------------------------------------------------
;   Macro	  covabrr
; ----------------------------------------------------------------------
;   Description   covariance matrix A*B, reduced rank VAR model 
; ----------------------------------------------------------------------
;   Usage         c = covabrr(a,b,ew,r,j,l,di,diord)
;   Input 
;     Parameter   a 
;     Definition     vector
;     Parameter   b 
;     Definition     vector
;     Parameter   ew 
;     Definition     matrix
;     Parameter   r 
;     Definition     integer 
;     Parameter   j 
;     Definition     integer
;     Parameter   l 
;     Definition     integer 
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   diord 
;     Definition     integer, dimension of the order
;   Output
;     Parameter   c
;     Definition     di x di matrix          
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich 971204, CH 980408
; ---------------------------------------------------------------------- 
 c = zeros(di,diord)
 if (j==l)
    k=1
    while (k<=r)
      if (k<>j)
      c=c+1/((ew[j,1]-ew[k,1])^2)*a[,k]*b[k,]
      endif
      k=k+1
   endo
   c=c*2*ew[j,1]
 endif
if (j<>l)
    c=-2*ew[l,1]/((ew[j,1]-ew[l,1])^2)*a[,l]*b[j,]
endif
endp
