proc(c)=covarr(a,ew,r,j,l,di)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  modelrr, covabc, covbrr, covabrr
; ----------------------------------------------------------------------
;   Macro	  covarr
; ----------------------------------------------------------------------
;   Description   covariance matrix A, reduced rank VAR model
; ----------------------------------------------------------------------
;   Usage         c = covarr(a,ew,r,j,l,di)
;   Input 
;     Parameter   a 
;     Definition     vector
;     Parameter   ew 
;     Definition     matrix
;     Parameter   r 
;     Definition     integer 
;     Parameter   j 
;     Definition     integer
;     Parameter   l 
;     Definition     integer 
;     Parameter   di 
;     Definition     integer, dimension of time series
;   Output
;     Parameter   c
;     Definition     di x di matrix          
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich 971204, CH 980408
; ---------------------------------------------------------------------- 
  c= zeros(di,di)
  m=di
  if (j==l)
    k=1
    while (k<=m)
      if (k<>j)
         c=c+(ew[j,1]+ew[k,1])/((ew[j,1]-ew[k,1])^2)*a[,k]*a[,k]'
      endif
      k=k+1
    endo
  endif
  if (j<>l)
    c=-(ew[j,1]+ew[l,1])/((ew[j,1]-ew[l,1])^2)*a[,l]*a[,j]'
  endif
endp
