proc(covf2)=covfore2(f,a,cova,covu,di,ord,adj,tb,te,h,typ)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     forec2, forecast 
; -----------------------------------------------------------------
;   Macro        covfore2
; -----------------------------------------------------------------
;   Description  Computes forecast MSE matrix for undiff. time series
; -----------------------------------------------------------------
;   Usage        covf2=covfore2(f,a,cova,covu,di,ord,adj,tb,te,h,typ)  
;   Input
;     Parameter   f
;     Definition      matrix
;     Parameter   a
;     Definition      matrix of parameters
;     Parameter   cova 
;     Definition    matrix, covariance matrix of parameters 
;     Parameter   covu 
;     Definition    matrix, covariance matrix of residuals
;     Parameter   di 
;     Definition    scalar, dimension of time series
;     Parameter   ord 
;     Definition    vector, order of series
;     Parameter   adj 
;     Definition     scalar, 1=if adjusted, 0=if not
;     Parameter   tb 
;     Definition    integer, (time) begin 
;     Parameter   te 
;     Definition    integer, (time) end
;     Parameter   h 
;     Definition    integer, forecast horizon
;     Parameter   typ 
;     Definition    integer, indicating the model type
;   Output
;     Parameter   covf2
;     Definition     matrix, forecast MSE 
; -----------------------------------------------------------------
;   Author    Christian Hafner 981230
; -----------------------------------------------------------------
  t=te-tb+1
  abig=aorBgen(a,di,ord,adj,typ)
  jota=jotaAorB(di,ord,adj,typ)
  phi=phigen(abig,jota,h,ord,di,typ)
  covf=sigma1(phi,covu,h)
  covf2=cfc1diff(h,covf,covu,phi,f,di)
  if ((adj==1) && (typ <> 6))
    covf2=covf2+covmwgen(covu,abig,ord,di,adj,h,typ)/t
  endif
endp
