proc(output)=covmatrix(x,MSSRin,Vin,b,colhx)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista collinearity confidenceb confidencey 
;              descriptivelinreg durbinwatson regressionstatistic
; -----------------------------------------------------------------------
; Macro        covmatrix
; -----------------------------------------------------------------------
; Description  computes the covariance matrix for beta after
;              regression analysis
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  ind=0.*matrix(cols(x))
  ind[Vin]=1
  x=(paf(x',ind))'
  x=matrix(rows(x))~x
  matrix=(inv(x'*x))
  Cov=MSSRin.*matrix
  i=0
  while (i<cols(Cov))
    i = i+1
    if(i==1)
      matrixstr=string("%10.4f ", Cov[,i])
      bhstr=string("b %2.0f       ",0)  
    endif
    if(i==cols(Cov))
      matrixstr=matrixstr+string("%10.4f ", Cov[,i])
      bhstr=bhstr+(string("b %2.0f ",i-1))+"  Variable(s)" 
    endif
    if((i<>1)&&(i<>cols(Cov)))
      matrixstr=matrixstr+string("%10.4f ", Cov[,i])
      bhstr=bhstr+(string("b %2.0f       ",i-1))
    endif
  endo
  bstr=string("b %2.0f ",0:(rows(b))-1)
  namestr="Constant"|colhx
  firstline="Covariance matrix of b"
  secondline="----------------------" 
  thirdline="           "+bhstr
  fourthline=bstr+matrixstr+"  "+namestr
  output=firstline|secondline|thirdline|fourthline
endp
