proc (re) = creal (z)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     complex cimag
; -----------------------------------------------------------------------
; Macro        creal
; -----------------------------------------------------------------------
; Description  Extracts real part of an complex array
; -----------------------------------------------------------------------
; Usage        y = creal (z)
; Input
;   Parameter  y
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  re
;   Definition n x p x d1 x ... x dn array real part of z
; -----------------------------------------------------------------------
; Example      library("math")
;              j = complex (0, 1)
;              creal(j)
; -----------------------------------------------------------------------
; Result       Contents of re

;              [1,]        0 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970530
; -----------------------------------------------------------------------
  error (comp(z, "re")<1, "creal : No real part in z found")
  error (comp(z, "im")<1, "creal : No imaginary part in z found")
  re = z.re
endp