proc(cr)=criterss(r,k,t,ord,di,tb,te,adj,cri,typ,ytt)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     modelss 
; -----------------------------------------------------------------
;   Macro        criterss
; -----------------------------------------------------------------
;   Description  calculates selection criteria for Subset VAR 
; -----------------------------------------------------------------
;   Usage        cr=criterss(r,k,t,ord,di,tb,te,adj,cri,typ,ytt)  
;   Input
;     Parameter   r  
;     Definition      matrix, restrictions of Subset VAR
;     Parameter   k 
;     Definition      integer, index
;     Parameter   t  
;     Definition      integer, sample size
;     Parameter   ord 
;     Definition      integer, VAR order
;     Parameter   di  
;     Definition      integer, dimension of time series
;     Parameter   tb 
;     Definition      integer, beginning of sample
;     Parameter   te  
;     Definition      integer, end of sample
;     Parameter   adj 
;     Definition      integer, 0=mean adjusted, 1=not mean adjusted
;     Parameter   cri  
;     Definition      integer, 1=AIC, 2=HQ, 3=SC, 4=none
;     Parameter   typ 
;     Definition      integer, model type (2=subset VAR)
;     Parameter   ytt
;     Definition      matrix, time series
;   Output
;     Parameter   cr
;     Definition       matrix of selection criteria  
; -----------------------------------------------------------------
;   Author    TP A2, CH 980409
; -----------------------------------------------------------------     
yz=ymulz(ord,di,tb,te,adj,typ,ytt)
ski=ytt[k,tb:te]*ytt[k,tb:te]'
if (max(sum(r)')>0)
   zz=zmulz(ord,di,tb,te,adj,0,typ,ytt)
   ski=ski-yz[k,]*r*inv(r'*zz*r)*r'*yz[k,]'
endif
switch
case (cri==1)
  cr=2/t*cols(r);  --------------- aic
case (cri==2)
  cr=(2*cols(r)*log(log(t)))/t; -- hq
case (cri == 3)
  cr=cols(r)*log(t)/t; ----------- sc
break
endsw
cr=log(ski/t)+cr
endp;
