proc(cross)=crosstable(x,xvars)
; ----------------------------------------------------------------------------
;  Library      stats
; ----------------------------------------------------------------------------
;  See_also     discrete table2 tablen
; ----------------------------------------------------------------------------
;   Macro       crosstable
; ----------------------------------------------------------------------------
;   Description  computes pairwise crosstables from all columns of a
;                data matrix, gives the result of a Chi-square 
;                independence test and computes contingency coefficients.
; ----------------------------------------------------------------------------
;   Usage        cross=crosstable(x{,xvars})
;   Input
;     Parameter   x  
;     Definition        n x p  matrix, the columns correspond to the variables.
;     Parameter   xvars
;     Definition        optional, p x 1  string vector, variable names. 
;   Output
;     Parameter   cross
;     Definition        string output, containing all crosstables of each
;                       combinations of columns of x, the result of the
;                       Chi-square independence tests and contingency 
;                       coefficients.
; ----------------------------------------------------------------------------
;   Example   library("stats")
;             randomize(970701)
;             x = ceil(normal(100,2)) ; rounded independent random numbers
;             crosstable(x)
; ----------------------------------------------------------------------------
;   Result    the crosstable of the columns of x. The significance level
;             of the Chi-square independence test should NOT indicate 
;             rejection.
; ----------------------------------------------------------------------------
;   Author    Torsten Kleinow, Marlene Mueller, Sigbert Klinke 970718
; ----------------------------------------------------------------------------
  if (exist(x)==9)
    x=x{1}
  endif
  if (exist(xvars)>0)
    if (cols(xvars)>1)
      xvars=reshape (xvars, cols(xvars)|rows(xvars)) ; transpostion!
    endif
  endif
;
  error(rows(dim(x))>2,"first argument must be vector or matrix")
;  error(exist(x)!=1,"first argument must be numeric")
;
  if (exist(xvars)>0)
    error(exist(xvars)!=2,"variable names should be strings!")
    error(rows(dim(xvars))>1,"variable names have wrong dimension")
    error(rows(xvars)!=cols(x),"variable names have wrong dimension")
  else
    xvars=string("%1.0f",1:cols(x))
  endif
  havestring=(exist(x)!=1)
;
  cross=" "
;
  if (1-havestring)
    x=(0*matrix(rows(x),cols(x))).*(x==0)+x.*(x!=0)
  endif
  cj=0
  while (cj<cols(x))
    cj=cj+1
    ci=0
    while (ci<cj-1)
      ci=ci+1
      {xr1,xr2,t}=table2(x[,ci]~x[,cj])
      n1=rows(xr1)
      n2=rows(xr2)
;
//  transform to string
      fmti=" %6.0f "
      if (havestring)
        fmtd=" %7.6s"
      else
        fmtd=" %6.4f "
      endif
      ss1="                   "
      ss2="-------------------"
//  compute length
      len1=matrix(n1)
      len2=matrix(n2)
      i=1
      while(i<=n1)
        k=1
        xr=xr1[i]
        if (1-havestring)
          if (isNumber(xr))
            while ((abs(xr)>=10))
              xr=xr1[i]/(10^k)
              k=k+1
            endo
            if (xr1[i]<0) 
              k=k+1
            endif 
            len1[i]=k
;          else
;            len1[i]=4
;            if (xr==-Inf)
;              len1[i]=5
;            endif  
          endif
        endif
        i=i+1
      endo
;
      i=1
      while(i<=n2)
        k=1
        xr=xr2[i]
        if (1-havestring)
          if (isNumber(xr))
            while ((abs(xr)>=10))
              xr=xr2[i]/(10^k)
              k=k+1
            endo
            if (xr2[i]<0) 
              k=k+1
            endif 
            len2[i]=k
;          else
;            len2[i]=4
;            if (xr==-Inf)
;              len2[i]=5
;            endif  
          endif
        endif
        i=i+1
      endo
;
      maxl1 = min(max(len1[,1])|6)
//
      i=1
      lv=substr(ss1,1,(maxl1+1)-len1[i])
      while(i<n1)
        i=i+1
        lv=lv|substr(ss1,1,(maxl1+1)-len1[i])
      endo
// 
      l=substr(ss2,1,maxl1+1)+"--------|------------"+substr(ss2,1,len2[1])
      sh=string(lv+fmtd+"                ",xr1)
      sh=substr(sh,1,maxl1+8)
      s=string(sh+" |"+substr(ss1,1,len2[1])+fmti,t[,1])
      if (havestring)
        z1=string(substr(ss1,1,maxl1)+"         |"+fmtd,xr2[1])
      else
        z1=string(substr(ss1,1,maxl1)+"         |     "+fmtd,xr2[1])
      endif
      zn=string(substr(ss1,1,maxl1)+"         |"+substr(ss1,1,len2[1])+fmti, sum(t[,1]))
      i=1
      while(i<n2)
        i=i+1
        l=l+"--------"+substr(ss2,1,len2[i])
        s=string(s+substr(ss1,1,len2[i])+fmti,t[,i])
        z1=string(z1+fmtd,xr2[i])
        zn=string(zn+substr(ss1,1,len2[i])+fmti,sum(t[,i]))
      endo
      l=l+"-|---------"
      if (havestring)
        z1=z1+"     |"
      else
        z1=z1+"|"
      endif
      s=s+string("     | "+fmti,sum(t,2))
      zn=string(zn+"     | "+fmti,sum(sum(t,2)))
      z01="Crosstable for variables "+xvars[ci]+", "+xvars[cj]
      s=z01|" "|z1|l|s|l|zn
//
// chi-statistic
//
      hrow=sum(t,2)                              ; rows sums
      hcol=sum(t)                                ; column sums
      n=sum(hcol,2)                                  ; n
      chistat=(t-(hrow*hcol)./n)^2./(hrow*hcol)
      chistat=n*sum(sum(chistat,2))         ; test statistic
      df=(rows(hrow)-1)*(cols(hcol)-1)      ; degress of freedom
      alpha=1-cdfc(chistat,df)              ; significance level
      conti=sqrt(chistat/(chistat+rows(x))) ; contingency coefficient
      cs=min(rows(t)|cols(t))               ; corrected contingency coefficient
      ccorr=conti*sqrt(cs/(cs-1))    
// 
      talpha=       "Chi^2 test of independence"
      talpha=talpha|" "
      schi  ="  chi^2 statistic:                   "+string("%6.2f",chistat)
      sdf   ="  degrees of freedom:                "+string("%6.0f",df)
      salpha="  significance level for rejection:  "+string("%6.4f",alpha)
      scont ="  contingency coefficient:           "+string("%6.2f",conti)
      sccont="  corrected contingency coefficient: "+string("%6.2f",ccorr)
      cross=cross|ss1|s|ss1|talpha|schi|sdf|salpha|" "|scont|sccont|ss1
    endo
  endo
endp
