proc(y)=denvalues(tr,dendat)
;kanta, denala, pinala
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also    dentoreg,
;             cartsplit, cartsplitopt, cartcv, leafnum, maketr, pred,
;             prederr, prune, prunecv, pruneseq, prunetot, ssr, kuva
; -----------------------------------------------------------------------
; Macro        denvalues
; -----------------------------------------------------------------------
; Description  Given a binary tree produced by cartsplit,
;              normalises the mean values of the leaves so that
;              the function represented by the binary tree
;              integrates to one.
; -----------------------------------------------------------------------
; Usage         val = denvalues (tr, dendat)
; Input        
;   Parameter  tr
;   Definition  list of vectors: data structure which represents a binary tree
;               and is produced by cartsplit procedure, contains vectors 
;               tr.val, tr.vec, tr.mean, tr.ssr, tr.nelem.
;               See cartsplit for the description of tr.
;   Parameter  dendat
;   Definition  n x p matrix: data matrix of i.i.d. observations. 
;               Data with which the density tree was estimated.
; Output       
;   Parameter  val
;   Definition  vector which has as many elements as there are elements
;               in the vectors which form the tree tr. 
;               In the positions which correspond to the leaf nodes
;               there are normalised values of vector tr.mean.
;               Values are normalised in such a way that 
;               the function represented by the binary tree
;               integrates to one. In other, nonterminal positions,
;               there are Inf.
; -----------------------------------------------------------------------
; Notes         The macro denvalues is intended to be applied to the
;               density estimation. The macro will make from a
;               binary tree corresponding to a non-negative function,
;               a binary tree which corresponds to a density function.
; -----------------------------------------------------------------------
; Example      ; loads the library xclust
;              library ("xclust")
;              ; generate the density data
;              randomize(1)
;              dendat=uniform(10)~(uniform(10)+1)
;              ; transform the density data to a regression data
;              regdat=dentoreg(dendat,4)
;              ; estimate the density tree
;              cs=cartsplit(regdat.ind,regdat.dep,#(1,1))
;              ; normalise the density estimate
;              cval=denvalues(cs,dendat)
;              cval
;              cs.mean=cval
; -----------------------------------------------------------------------
; Result
; Contents of cval
; [ 1,] Inf 
; [ 2,] Inf 
; [ 3,] Inf 
; [ 4,] 0.183560 
; [ 5,] 0.351490 
; [ 6,] Inf 
; [ 7,] 0.461948 
; [ 8,] 0.550679 
; [ 9,] Inf 
; [10,] Inf 
; [11,] Inf 
; [12,] 0.183560 
; [13,] 0.183560 
; [14,] Inf 
; [15,] 0.183560 
; [16,] 0.351490 
; [17,] Inf 
; [18,] 0.461948 
; [19,] Inf 
; [20,] 0.183560 
; [21,] 0.351490 
; -----------------------------------------------------------------------
; Author       Jussi Klemelae, 980323         
; -----------------------------------------------------------------------
kantaja=kanta(dendat)
elem=dim(tr.nelem)
tulos=matrix(elem)/0
alavec=denala(tr,dendat)
summa=0
i=1
while (i<=elem)
   if (tr.vec[i]==NaN)  ;ollaan lehdessa
        summa=summa+tr.mean[i]*alavec[i]
        tulos[i]=tr.mean[i]
   endif
i=i+1
endo
y=tulos/summa
endp
    
          
