proc(data)=doista(x)   
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     istadata istagraphic istastatistic istatransformation 
; -----------------------------------------------------------------------
; Macro        doista
; -----------------------------------------------------------------------
; Description  starts ISTA with input data x. If x is a list concerning
;              data.colname, data.colvar, data.colmissing, data.coltype
;              data.rowmissing, data.rowcase, data.randcase and data.x    
;              then theseparameters are used in ISTA otherwise a list
;              is automatically created consisting default values.
;------------------------------------------------------------------------
; Usage        proc(data)=doista(x)   
; Input
;   Parameter  x 
;   Definition a list or a n x p x d1 x ... x dn array    
;   Definition n x 1 array   
;
; Output
;   Parameter  data
;   Definition list  
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  switch
  case(exist("x")==9)
    data=x
    break
  case(exist("x")==1)
    data=defaultdata(x)
    break
  default
    error(1, "analyze: Data not numeric")
  endsw  
  selhead="ISTA Data analysis"
  selitem="Data"|"Transformation"|"Statistic"
  selitem=selitem|"Graphic"
  do
    sel=selectitem(selhead, selitem)
    if(sel[1])
      data = istadata (data)
    endif
    if(sel[2])
      data = istatransformation (data)
    endif
    if(sel[3])
      data = istastatistic (data)
    endif
    if(sel[4])
      data = istagraphic (data)
    endif
  until(sum(sel).=0)
endp