proc(output,usum,usumname)=durbinwatson(x,y,b,Vin)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista collinearity confidenceb confidencey covmatrix
;              descriptiveshort descriptivelinreg regressionstatistic 
;              summarize
; -----------------------------------------------------------------------
; Macro        durbinwatson
; -----------------------------------------------------------------------
; Description  performes the durbin watson test for autocorrelation of
;              the X variables after regression analysis
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter 980616
;------------------------------------------------------------------------
  ind=0.*matrix(cols(x))
  ind[Vin]=1
  x=(paf(x',ind))'
  x=matrix(rows(x))~x
  p=cols(x)
  n=rows(x)
  dfR=n-rows(b)
  yhat  = x*b
  u=y-yhat
  use=sqrt(sum(u^2)/dfR)
  ustan=u./use
  u1=u[2:rows(u)]
  u2=u[1:(rows(u)-1)]
  uu=sum((u1-u2)^2)
  SSR = sum((yhat-y)^2)   
  d=uu./SSR
  usum=u~ustan
  usumname="RESID"|"ZRESID"
  dstr=string("Durbin-Watson test statistic: %5.3f",d)
  pstr=string("(Number of variables: %3.0f",p)+")"
  nstr=string("(Cases: %5.0f",n)+")"
  firstline ="Durbin-Watson for Serial Correlation"
  secondline="------------------------------------"
  thirdline=dstr|pstr|nstr
  output=firstline|secondline|thirdline
endp
