proc(w,z)=eisrs(a)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; Macro        eisrs
; -----------------------------------------------------------------------
; Description  Computes the eigenvalues and eigenvectors of a real
;              symmetric square matrix       
; -----------------------------------------------------------------------
; Keywords     eigen values, eigen vectors, real symmetric square matrix
; -----------------------------------------------------------------------
; Usage       {w, z} = eisrs(a)
; Input     
;  Parameter  a
;  Definition n x n matrix
; Output    
;  Parameter  w
;  Definition n x 1 vector of eigenvalues
;  Parameter  z
;  Definition n x n matrix of eigenvectors
; -----------------------------------------------------------------------
; Example    
;        library("math")
;        y1 = #(1, -1, 0)
;        y2 = #(-1, 2, -1)
;        y3 = #(0, -1, 1)
;        a = y1~y2~y3
;        {w, z} = eisrs(a)
;        w
;        z
; -----------------------------------------------------------------------
; Result     
;        Contents of w
;
;        [1,] -2.5653e-16 
;        [2,]        1 
;        [3,]        3 
;        Contents of z
;
;        [1,]  0.57735  0.70711  0.40825 
;        [2,]  0.57735 -2.8623e-16  -0.8165 
;        [3,]  0.57735 -0.70711  0.40825 
;
; -----------------------------------------------------------------------
; Author    Fabian Noetzel
; -----------------------------------------------------------------------
  
  os=getenv("os")
  if (os=="windows")
    h = dlopen("eispack.dll")
  else                                       ; Unix
    h = dlopen("eispack.so")
  endif 
  
  w = matrix(rows(a))      
  z = a.*0        
  matz = 1       
  nm = rows(a)
  n = cols(a)
  
  param = list(nm, n, a, w, matz, z)
  byrow = 0|0|0|0|0|0
  type = -8|-8|8|8|-4|8
  opt = list(type, byrow)
   
  if (os=="windows")
    err = dlcallex(h, "_rs", param, opt)
  else
    err = dlcallex(h, "rs", param, opt) 
  endif
 
  id = "eisrs"
  ErrDLL(err, id)
 
  w=param.w
  z=param.z
  
  dlclose(h)
  
endp