proc(rotm,tourparam)=eppft(tourparamin, x)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plotgt
; -----------------------------------------------------------------------
; Macro        eppft
; -----------------------------------------------------------------------
; Description  Optimizes the Friedman-Tukey index.
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971112
; -----------------------------------------------------------------------
  tourparam = tourparamin
  if (tourparam.eft<0.01)
    tourparam.eft = 1    
  endif
  p = rows(tourparam.eftrot)
  tourparam.eft = tourparam.eft* (1-tourparam.eftdt)
  rotm = orthonormal(tourparam.eftrot + tourparam.eft.*normal(p,p))
  px   = x*rotm[,1:2]
  h    = tourparam.efth.*matrix(1,2)
  ind  = indexfriedmantukey (px, h)
  if (ind>tourparam.eftind)
    tourparam.eftind = ind
    tourparam.eftrot = rotm
  else
    rotm = tourparam.eftrot
  endif
endp
