proc(rotm,tourparam)=eppleg(tourparamin, x)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plotgt
; -----------------------------------------------------------------------
; Macro        eppleg
; -----------------------------------------------------------------------
; Description  Optimizes the Legendre index.
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971113
; -----------------------------------------------------------------------
  tourparam = tourparamin
  if (tourparam.elegt<0.01)
    tourparam.elegt = 1    
  endif
  p = rows(tourparam.elegrot)
  tourparam.elegt = tourparam.elegt * (1-tourparam.elegdt)
  rotm = orthonormal(tourparam.elegrot + tourparam.elegt.*normal(p,p))
  px   = x*rotm[,1:2]
  h    = tourparam.elegh.*matrix(1,2)
  ind  = indexlegendre (px, h)
  if (ind>tourparam.elegind)
    tourparam.elegind = ind
    tourparam.elegrot = rotm
  else
    rotm = tourparam.elegrot
  endif
endp
