proc(ev,ew)=evci(y,dy,ord,b,e,t,di);
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  
; ----------------------------------------------------------------------
;   Macro	  evci
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         {ev,ew} = evci(y,dy,ord,b,e,t,di)
;   Input 
;     Parameter   y 
;     Definition     matrix, time series
;     Parameter   dy 
;     Definition     matrix, differenced time series
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   b 
;     Definition     vector 
;     Parameter   e 
;     Definition     vector 
;     Parameter   t 
;     Definition     vector, number of observations
;     Parameter   di 
;     Definition     integer, dimension of time series
;   Output
;     Parameter   ev
;     Definition     matrix, eigenvectors
;     Parameter   ew
;     Definition     matrix, eigenvalues
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ----------------------------------------------------------------------
  l=lgenci(y,dy,ord,b,e,t,di);
  s10=sijci(y,dy,ord,b,e,t,di,1,0);
  x=l*s10*inv(sijci(y,dy,ord,b,e,t,di,0,0))*s10'*l';
  {ew,ev} = eigsm(x);
  ewv = sort(ew~ev')
  ew = ewv[,1]
  ev = ewv[,2:cols(ewv)]'	
  ew=rev(ew);
  ev=rev(ev')';
  ev=l'*ev;
endp;
