proc() = forecast(a,cova,covu,ord,adj,tb,te,ytt,typ,header,outp)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     forec2 
; -----------------------------------------------------------------
;   Macro        forecast
; -----------------------------------------------------------------
;   Description  Forecasting in VAR Models
; -----------------------------------------------------------------
;   Usage        forecast(a,cova,covu,ord,adj,tb,te,ytt,typ,header,outp)  
;   Input
;     Parameter   a
;     Definition      matrix of parameters
;     Parameter   cova
;     Definition      covariance matrix of parameter estimates
;     Parameter   covu
;     Definition      covariance matrix of residuals
;     Parameter   ord 
;     Definition    vector, order of series
;     Parameter   adj 
;     Definition     scalar, 1=if adjusted, 0=if not
;     Parameter   tb 
;     Definition     integer, (time) begin
;     Parameter   te 
;     Definition     integer, (time) end
;     Parameter   ytt 
;     Definition      k x n matrix, the transformed (and transposed) 
;                     time series  
;     Parameter   typ  
;     Definition      1,2 or 3, giving the type of model: 1=Full,
;                     2=Subset, 3=Reduced Rank
;     Parameter   header
;     Definition      list of 7 objects:   natlog,diff,origyear,
;                     periodicity,origperiod,name,exclude
;     Parameter   outp
;     Definition      integer, (1=output to file, 0 = no output)

; -----------------------------------------------------------------
;   Author    Christian Hafner 981230
; -----------------------------------------------------------------
switch
case (typ==1)
   mod="Full VAR"
case (typ==2)
   mod="Subset VAR"
case (typ==3)
   mod="Reduced Rank VAR"
case (typ==4)
   mod="Cointegration"
   break
endsw
  t=te-tb+1 
  di=rows(ytt)
  h=12
  alpha=0.95
  z=1.96
  s=1
  while(s<4)
  item=" Change Forecast Horizon (default="+string("%2.0f)",h)
  item=item|" Change Forecast Interval Length (default="+string("%1.2f)",alpha)
  item=item|" Continue"|" Back"
  s=selectitem(" Please select ",item,"single")
  s=s'*(1:4)
  switch
  case (s==1)
     h=readvalue(" Forecast horizon: ",h)
  case (s==2)
     items="0.99"|"0.95"|"0.90"  
     alpha=selectitem("Select Coverage Probability (alpha)",items,"single")
     z=alpha'*(2.576|1.96|1.645)
     alpha=alpha'*(0.99|0.95|0.90)
  case (s==3)
    mw=zeros(di,1)
    if (adj==1)
      mw=mean(ytt[,tb:te]')'
    endif
    yh=prognose(a,mw,ord,h,te,di,adj,typ,ytt)+kron(ones(h,1),mw)
    yiv=0
    if (typ<>5)
      covf=covforec(a,cova,covu,ord,adj,tb,te,h,typ,ytt)
      yiv=ivforec(h,yh,covf,z)
    endif
    yh=reshape(yh,di|h)'
    yiv=reshape(vec(yiv'),(2*di)|h)'
;
  noback=1
  while (noback==1)
    head = "Forecasting which variable?"
    item=header.name[1]
    j=2
    while (j<= di)
      item=item|header.name[j]
      j=j+1
    endo
    item=item|"Back"
    i=selectitem(head,item,"single") 
    i=i'*(1:(di+1))
    if (i<=di)
      d1=createdisplay(1,1)
      t1=aseq(te-11,12,1)
      y1=t1~ytt[i,aseq(te-11,12,1)]'
      setmaskp(y1, 0, 0, 0)
      setmaskl(y1,(1:rows(y1))',0,1,2)
      t2=aseq(te,h+1,1)
      y2=t2~(ytt[i,te]'|yh[,i])
      setmaskp(y2, 0, 0, 0)
      setmaskl(y2,(1:rows(y2))',1,1,2)
      s1=t2~(ytt[i,te]'|yiv[,2*i-1])
      setmaskp(s1, 0, 0, 0)
      setmaskl(s1,(1:rows(y2))',1,2,2)
      s2=t2~(ytt[i,te]'|yiv[,2*i])
      setmaskp(s2, 0, 0, 0)
      setmaskl(s2,(1:rows(y2))',1,2,2)
      show(d1,1,1,y1,y2,s1,s2)
      fhead=mod+" Forecast for "+header.name[i]
      setgopt(d1,1,1,"title",fhead)
;
      d2=createdisplay(1,1)
      str1=("      "+fhead)|" "
      str2=" Horizon"+" Forecast"+"  F. Interval"+string(" (alpha=%1.2f)",alpha)
      str3=string("  %5.0f",1:h)+string("  %5.3f",yh[,i])
      str3=str3+string("    [%5.3f ,",yiv[,2*i-1])+string(" %5.3f]",yiv[,2*i])
      str=str1|str2|str3
      show(d2,1,1,str)
      if (outp==1)
            fhead
            str
      endif
    else
     noback=0
    endif
   endo
  case (s==4) 
     break
  endsw
  endo
  d1=0
  d2=0 
endp
