proc(m2) = fracbrown(p, nu, alpha)
; ---------------------------------------------------------------------
; Library     times
; ---------------------------------------------------------------------
; See_also    hurst lo kpss
; ---------------------------------------------------------------------
; Macro       fracbrown
; ---------------------------------------------------------------------
; Description the result*normal(2*p*nu+1) gives a fractional brownian motion
;		with respect to alpha=2*H ( H = Hurst coefficent)
; ---------------------------------------------------------------------
; Usage       (m2)=fracbrown(p,nu,alpha)
; Input       
; Parameter   p
; Definition  scalar, temporal scale factor
; Parameter   nu
; Definition  scalar, the resulting matrix is a (2*p*nu+1) matrix
; Parameter   alpha
; Definition  scalar, coefficent of the frac. brownian motion
; Output      
; Parameter   m2
; Definition  (2*p*nu+1)x(2*p*nu+1) matrix
; ---------------------------------------------------------------------
; Notes      The covariance matrix M of m2*normal(p*nu+1) has the 
;		following structur:
; &nl;
;		M = m2*m2' ; 
; &nl;
;		M[i,j] = (1/2)*(| s[i] |^alpha + | s[j] |^alpha - | s[i]-s[j] |^alpha)
;		, s=(-p*nu, ..., p*nu)
; ---------------------------------------------------------------------
; Example     	func("fracbrown.xpl")	// load macro
;		func("hurst.xpl")	// load macro
;		randomize(234)
;		p=1
;		nu = 50
;		alpha = 1.5
;		// simulate frac. BM
;		x=fracbrown(p,nu,alpha)*normal(2*p*nu+1)
;		dim(x)			// 2*p*nu+1
;		h=hurst(x,12)
;		2*h.b[2]		// estimated alpha
; ---------------------------------------------------------------------
; Result      	Contents of dim
;		[1,]      101 
;		Contents of _tmp
;		[1,]   1.5237 
; ---------------------------------------------------------------------
; Keywords    fractional brownian motion, Hurst, long memory
; ---------------------------------------------------------------------
; Reference   Beran, J. (1994). Statistics for Long-Memory Processes.
;		Chapman and Hall, London
; &nl;
; &nl;
;	      Hall, P., Hrdle, W., Kleinow, T., Schmidt, P. (1999).
;		Semipara. bootstrap approach to hypothesis tests and 
;		confidence intervals for the Hurst coefficent
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author       W. Hrdle, T. Kleinow
; ---------------------------------------------------------------------
// m2*normal(rows(m2)) = normal dist. vector with
// cov. of a frac. BM with alpha
  t = (-p*nu:p*nu)/nu	// time -p ... p
  s = t
  nt = rows(t)		// = 2*p*nu+1
  c = matrix(nt, nt)	// cov.matrix of the resulting frac.BM
  i = 1
// ********** i->
  while (i <= nt)
    j = 1
// ************ j->
    while (j <= nt)
      c[i,j] = 0.5*(abs(s[i])^alpha + abs(t[j])^alpha - abs(s[i]-t[j])^alpha)
      j = j+1
    endo
// ************ <-j
    i =i + 1
  endo
// ********** <-i
  {e, v} = eigsm(c)
  m2 = v*diag(sqrt(e))*v'
endp

