proc() = gamtest()
; -----------------------------------------------------------------
; Library        gam
; -----------------------------------------------------------------
;  See_also     
; -----------------------------------------------------------------
;   Macro        gamtest
; -----------------------------------------------------------------
;   Description  tests all abovementioned macros of gam.lib    
; -----------------------------------------------------------------
;   Usage        gamtest()
; -----------------------------------------------------------------
;   Author       Stefan Sperlich  961030 
; -----------------------------------------------------------------
   ; library("gam")
 ;
 ; for    intest1
 ;        
           n     = 250
           x     = uniform(n,4)*4-2
           g1    = 2*x[,1]
           g2    = x[,2]^2 - 4/3
           g3    = exp(x[,3])
           g4    = sin(1.5*x[,4])
           y     = g1 + g2 + g3 + g4
           xgrid = grid(-1.8,0.2,19)
           xgrid = xgrid~xgrid 
           h     = #(1.0, 0.75)		      ; we are interested in
           g     = #(1.3, 1.0, 1.5, 1.5)      ; the shape of g1, g2
           gest= intest1(x,y,xgrid,h,g)
"intest1 ready"
 ;
 ; for    intest
 ; 
            randomize(1234)
            n     = 100
            d     = 3
            x     = uniform(n,d)*2-1
            g1    = 2*x[,1]
            g2    = x[,2]^2 
            g2    = g2 -mean(g2)
            g3    = sin(3*x[,3])
            eps   = normal(n,1) * sqrt(0.5)
            y     = g1 + g2 + g3 + eps
            tg    = grid(-0.8,0.1,19)
            tg    = tg~tg 
            h     = #(1.2, 1.0)          ; we are interested in
            g     = #(1.4, 1.2, 1.6)     ; the shape of g1, g2
            loc   = 1
            opt   = list(tg)
            gest  = intest(x,y,h,g,loc,opt)
"intest ready"
 ;
 ; for    backfit
 ;   
     n   = 150
     x   = normal(n,4)
     eps = normal(n,1) * sqrt(0.75)
     y   = x[,3] - x[,4]/4 - sin(2*x[,1]) + x[,2]^2 +eps
     h   = 0.25
   {f,b,const} = backfit(x,y,h,0,"qua",2) 
    b
"backfit ready"
 ;
 ; for    pcad
 ;   
    n = 100
    v =uniform(n,4)
    x =v[,2:4]
    y =x[,1]^2+0.1*x[,2]+normal(n)
    h =0.5
    bn=0.02 
    gest=pcad(x,x,y,h,bn)
"pcad ready"
 ;
 ; for    gintest
 ;        
          n     = 150
          x     = uniform(n,4)*4-2
          g1    = 2*x[,1]
          g2    = x[,2]^2 - 4/3
          g3    = exp(x[,3])
          g4    = sin(1.5*x[,4])
          eps   = normal(n,1) * sqrt(0.5)
          y     = g1 + g2 + g3 + g4 + eps
          y     = (y>mean(y))
          tg    = grid(-1.8,0.2,19)
          tg    = tg~tg
          opt   = list(tg) 
          h     = #(1.5, 1.2)		; we are interested in
          g     = #(1.7, 1.4, 1.7, 1.7)   ; the shape of g1, g2
          loc   = 1
          link  = "bilo"
          gest  = gintest(link,x,y,h,g,loc,opt)
"gintest ready"
 ;
 ; for    intestpl
 ;        
            n  = 50
            loc= 2
            d  = 2
            dis= 2
            xd = matrix(n,dis)
            xc = uniform(n,d)*2-1
            xh = uniform(n,dis) 
            xd[,1]= 3*(xh.>=0.8) + 2*((0.8.>xh) && (xh.>=0.3)) 
            xd[,1]= xd[,1] + (0.3.>xh) 
            xd[,2]= (xh.> (1/3)) 
            x     = xc~xd
            g1    = 2*x[,1]
            g2    = (2*x[,2])^2 
            g2 = g2 -mean(g2)
            m     = g1 + g2 + xd*(0.2|-1.0) 
            y     = m + normal(n,1)*0.25
            h     = #(1.4, 1.4)	
            g     = #(1.4, 1.4)    
         {gest,b} = intestpl(xd,xc,y,h,g,loc)   
"intestpl ready"
 ;
 ; for    wavetest
 ;        
            n   = 100
            randomize(1234)
            x   = normal(n,3)
            eps = normal(n,1) * sqrt(0.8)
            y   = sin(2*x[,1]) + x[,2]^2 + 2*x[,3] +eps
            p   = 1
            erg = wavetest(x,y,p) 
"wavetest ready"
endp 
