proc(u)=gennorm(n,mu,sig)
;------------------------------------------------------------------------
; Library	xplore
;------------------------------------------------------------------------
; See_also	normal 		genar
;------------------------------------------------------------------------
; Keywords      random number generation, random variables
; -----------------------------------------------------------------
; Macro		gennorm
;------------------------------------------------------------------------
; Description   Generates observations from a multivariate normal 
; 		distribution with given mean vector and covariance 
;               matrix.
; ----------------------------------------------------------------------- 
; Usage		u=gennorm(n,mu,s)                 
;------------------------------------------------------------------------
; Input                                                                     
; Parameter	n 
; Definition		sample size 
; Parameter	mu  
; Definition		m x 1  mean vector 
; Parameter	sig
; Definition		m x m  covariance matrix                                      
; Output                                                                     
; Parameter	u     
; Definition		n x m 	matrix of observations                 
; ------------------------------------------------------------------------
;  Example
;            library("xplore") 	
;	     n	= 100				; sample size
;	     ss	= #(1,0.7)~#(0.7,1)		; covariance matrix
;	     mu	= #(0,0)			; mean vector
;	     u	= gennorm(n, mu, ss)		
;	     d	= createdisplay(1,1)
;	     show(d,1,1,u)
; ----------------------------------------------------------------------------
;   Result   Shows observations from a multivariate normal distribution
;            with mean vector mu and covariance matrix ss. 
; ----------------------------------------------------------------------------
; Author	charles de garchy,   961011 
; ----------------------------------------------------------------------------
	m	=	cols(sig)
	{va,ve}	=	eigsm(sig)
	ll	=	sqrt(diag(va))
	sh	=	ve*ll*ve'
	u	=	mu'+normal(n,m)*sh'
endp