proc(lr,alpha)=glmlrtest(loglik0,dim0,loglik1,dim1)
; ----------------------------------------------------------------------------
; Library       glm
; ----------------------------------------------------------------------------
;  See_also     glmest glmstat glmll 
; ----------------------------------------------------------------------------
;   Macro       glmlrtest
; ----------------------------------------------------------------------------
;   Description  glmlrtest performs a likelihood ratio test of two
;                nested GLM.
; ----------------------------------------------------------------------------
;   Link  ../tutorials/glmstart.html Tutorial: GLM in XploRe 
; ----------------------------------------------------------------------------
;   Usage        {lr,alpha} = glmlrtest(loglik0,dim0,loglik1,dim1)
;   Input
;     Parameter   loglik0 
;     Definition        scalar, log-likelihood of the hypothesis model.
;     Parameter   dim0  
;     Definition        integer, dimension of the hypothesis model.
;     Parameter   loglik1 
;     Definition        scalar, log-likelihood of the alternative model,
;                       loglik1 >= loglik0.
;     Parameter   dim1  
;     Definition        integer, dimension of the hypothesis model,
;                       dim1 >= dim0.
;   Output
;     Parameter   lr  
;     Definition        scalar, value of the lr test statistic.
;     Parameter   alpha  
;     Definition        scalar, significance level at which hypothesis
;                       is rejected.
; ----------------------------------------------------------------------------
;   Example   library("glm")
;             n = 100
;             x  = normal(n)
;             eps= normal(n)
;             y  = x/3+eps
;             one =matrix(n)
;             mod0=glmest("noid",one,y)    ; constant regression
;             mod1=glmest("noid",one~x,y)  ; linear regression
;             {lr,alpha}=glmlrtest(mod0.stat.loglik,1,mod1.stat.loglik,2)
;             alpha
; ----------------------------------------------------------------------------
;   Result    The significance level (smallest level) at which the constant
;             regression model is rejected.
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; ----------------------------------------------------------------------------
;
  error( dim(dim(loglik0))!=1, "loglik0 is not scalar!")
  error( (loglik1<loglik0)||(dim(dim(loglik1))!=1), "loglik1 is not a scalar >= loglik0!")
  error( dim(dim(dim0))!=1, "dim0 is not scalar!")
  error( dim(dim(dim1))!=1, "dim1 is not scalar!")
  error( (dim1==dim0)&&(loglik1!=loglik0), "nonested models!")
  error( (dim0<=0), "dim0 is > 0!")
  error( (dim1<dim0), "dim1 is not >= dim0!")
; 
  if (dim0==dim1)
    lr=0
    alpha=0
  else
    lr = 2 .*(loglik1-loglik0)
    alpha = 1-cdfc(lr,dim1-dim0)
  endif
endp

