proc(ap)=grandrews(x, nt, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grpcp grcontour3 grsunflower plotandrews
; -----------------------------------------------------------------------
; Macro        grandrews
; -----------------------------------------------------------------------
; Description  Generates an Andrews plot.
; -----------------------------------------------------------------------
; Usage        bp = grandrews (x, nt {, col})
; Input
;   Parameter  x
;   Definition n x p     matrix
;   Parameter  nt
;   Definition scalar    number of gridpoints in [-pi,pi]
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      ; load the library graphic
;              library ("graphic")
;              ; load the swiss banknote data
;	       x  = read("bank2")
;              ; standardize x
;              x  = (x-mean(x))./sqrt(var(x))
;              ; select 20 observations
;              x  = x[90:110,]
;              ; generate the andrews curves
;              bp = grandrews (x, 50)
;              ; show the andrews curves
;              d  = createdisplay (1,1)
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows an Andrews plot
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, andrews curves
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 961017
; -----------------------------------------------------------------------
  if (exist("col").<>1)
    col = 0
  endif
;  xs = (x-mean(x))./sqrt(var(x))
  xs = x
  t = grid (-pi, 2*pi/(nt-1), nt)
  i = 1
  n = rows(x)
  p = cols(x)
  j = 1
  ft = 1./sqrt(2).*matrix(nt)
  while (i.<p)
    i=i+1
    if (abs(i/2-floor(i/2)) < 0.1)
      ft = ft~sin(j.*t)
    else
      ft = ft~cos(j.*t)
      j = j+1
    endif
  endo
  i = 0
  while (i.<n)
    i = i+1
    ind = (nt*(i-1)+1):(i.*nt)
    if (i.=1)
      ap = t~(ft*trans(xs[i,]))
      li = ind'
    else
      ap = ap|(t~ft*trans(xs[i,]))
      li = li|trans(ind)
    endif
  endo
  setmaskp (ap, 0, 0, 0)
  setmaskl (ap, li, col, 1, 2)
endp
