proc()=graphicmain()
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     graphictest
; -----------------------------------------------------------------------
; Macro        graphicmain
; -----------------------------------------------------------------------
; Description  Generates graphical constants and loads all libraries
;              necessary for the graphics.
; -----------------------------------------------------------------------
; Usage        library("graphic")
; -----------------------------------------------------------------------
; Notes        The graphical constant grc contains:
;
;              grc.col                  standard colors (not RGB !)
;              grc.rgb                  rgb colors
;              grc.hls                  hls colors
;              grc.sym                  standard symbols
;              grc.lt                   standard linetypes
;              grc.prep                 data preparation
;              grc.splom                diagonal plots for splom
;              grc.star                 optional parameters for grstar
;
;	       grc.col.black		black color
;	       grc.col.blue		blue color
;	       grc.col.green            green color
;              grc.col.cyan             cyan color
;              grc.col.red              red color
;              grc.col.magenta          magenta color
;              grc.col.yellow           yellow color
;              grc.col.white            white color
;
;	       grc.rgb.black		black color in RGB
;	       grc.rgb.blue		blue color in RGB
;	       grc.rgb.green            green color in RGB
;              grc.rgb.cyan             cyan color in RGB
;              grc.rgb.red              red color in RGB
;              grc.rgb.magenta          magenta color in RGB
;              grc.rgb.yellow           yellow color in RGB
;              grc.rgb.white            white color in RGB
;
;	       grc.hls.black		black color in HLS
;	       grc.hls.blue		blue color in HLS
;	       grc.hls.green            green color in HLS
;              grc.hls.cyan             cyan color in HLS
;              grc.hls.red              red color in HLS
;              grc.hls.magenta          magenta color in HLS
;              grc.hls.yellow           yellow color in HLS
;              grc.hls.white            white color in HLS
;
;	       grc.sym.nopoint		no point
;              grc.sym.point		point
;              grc.sym.rect		rectangle
;              grc.sym.circle		circle
;              grc.sym.triangle		triangle
;              grc.sym.rhombus		rhombus
;              grc.sym.frect		filled rectangle
;              grc.sym.fcircle		filled circle
;              grc.sym.frhombus		filled rhombus
;              grc.sym.ftriangle	filled triangle
;              grc.sym.star		star
;              grc.sym.cross 		cross
;
;	       grc.lt.noline            no line
;              grc.lt.solid             solid line
;              grc.lt.dash              dashed line (1:1)
;
;              grc.prep.inter           interactive selection
;              grc.prep.none            no transformation
;              grc.prep.standard        standardize
;              grc.prep.zeroone         to [0,1]
;              grc.prep.pcacov          pca on cov matrix
;              grc.prep.pcacorr         pca on corr matrix
;              grc.prep.sphere          sphering
;
;              grc.splom.inter          interactive selection
;              grc.splom.none           no plot
;              grc.splom.boxplotx       boxplot parallel to x
;              grc.splom.boxploty       boxplot parallel to y
;              grc.splom.dotplotx       dotplot parallel to x
;              grc.splom.dotploty       dotplot parallel to y
;              grc.splom.qqnplot        qqplot with normal distribution
;
;              grc.star.none            no reference
;              grc.star.standard        reference mean / std. dev
;              grc.star.robust          reference median / iqr
;
;              grc.prime                the first prime number below 1000
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970201
; -----------------------------------------------------------------------
;  s2d = createdisplay (1,1)
  black = 0
  blue =  1
  green = 2
  cyan = 3
  red = 4
  magenta = 5
  yellow = 6
  white = 7
  col = list (black, blue, green, cyan, red, magenta, yellow, white)
  black = 0~0~0
  blue =  0~0~255
  green = 0~255~0
  cyan = 0~255~255
  red = 255~0~0
  magenta = 255~0~255
  yellow = 255~255~0
  white = 255~255~255
  rgb = list (black, blue, green, cyan, red, magenta, yellow, white)
  black = 0~1~0
  blue =  240~0.5~1
  green = 120~0.5~1
  cyan = 180~0.5~1
  red = 0~0.5~1
  magenta = 300~0.5~1
  yellow = 60~0.5~1
  white = 0~0~0
  hls = list (black, blue, green, cyan, red, magenta, yellow, white)
  nopoint = 0
  point = 1
  rect = 2
  circle = 3
  triangle = 4
  rhombus = 6
  frect = 7
  fcircle = 8
  frhombus = 9
  ftriangle = 10
  cross = 11
  star = 12 
  sym = list (nopoint, point, rect, circle, triangle, rhombus, frect, fcircle, frhombus, ftriangle, star, cross) 
  noline = 0
  solid = 1
  dash = 2
  lt = list (noline, solid, dash)
  inter = -1
  none = 0
  standard = 1
  zeroone = 2
  pcacov = 3
  pcacorr = 4
  sphere = 5
  prep = list(inter, none, standard, zeroone, pcacov, pcacorr, sphere)  
  boxplotx = 1
  boxploty = 2
  dotplotx = 3
  dotploty = 4
  qqnplot  = 5
  splom = list(inter, none, dotplotx, dotploty, boxplotx, boxploty, qqnplot)
  standard = 1
  robust   = 2
  star = list(none, standard, robust)
  prime = #(2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97)
  prime = prime|#(101,103,107,109,113,127,131,137,139,149,151,157,163,167,173,179,181,191,193,197,199)
  prime = prime|#(211,223,229,233,239,241,251,257,263,269,271,277,281,283,293)
  prime = prime|#(307,311,313,317,331,337,347,349,353,359,367,373,379,383,389,397)
  prime = prime|#(401,409,419,421,431,433,439,443,449,457,461,463,467,479,487,491,499)
  prime = prime|#(503,509,521,523,541,547,557,563,569,571,577,587,593)
  prime = prime|#(601,607,613,617,619,631,641,643,647,653,659,661,673,677,683,691)
  prime = prime|#(701,709,719,727,733,739,743,751,757,761,769,773,787,797)
  prime = prime|#(809,811,821,823,827,829,839,853,857,859,863,877,881,883,887)
  prime = prime|#(907,911,919,929,937,941,947,953,967,971,977,983,991,997)
  grc = list(col, rgb, hls, sym, lt, prep, splom, star, prime)
  putglobal("grc")
  library ("xplore")
endp