proc(outColors)=grcolorscheme(inColorScheme)
; ---------------------------------------------------------------------
; Library     graphic
; ---------------------------------------------------------------------
; See_also    dispdot freecolor createcolor
; ---------------------------------------------------------------------
; Macro       grcolorscheme
; ---------------------------------------------------------------------
; Description Returns a vector of rgb colors.
; ---------------------------------------------------------------------
; Usage       (outColors)=grcolorscheme(inColorScheme)
; Input       
; Parameter   inColorScheme
; Definition  String. The color scheme to be returned. Valid are: 
;             "topographic", "greyscale"
; Output      
; Parameter   outColors
; Definition  n x 3 vector. Can be treated as rgb values for the colors
;             of inColorScheme.
; ---------------------------------------------------------------------
; Notes       Calls freecolor() and createcolor() for the colors of the 
;             color scheme.
; ---------------------------------------------------------------------
; Example     library("graphic")
;             colors = grcolorscheme("grey")
;             colors
; ---------------------------------------------------------------------
; Result      Contents of colors
;             [1,]        0        0        0 
;             [2,]       30       30       30 
;             [3,]       60       60       60 
;             [4,]       90       90       90 
;             [5,]      120      120      120 
;             [6,]      150      150      150 
;             [7,]      180      180      180 
;             [8,]      210      210      210 
;             [9,]      240      240      240 
; 
; ---------------------------------------------------------------------
; Keywords    color
; ---------------------------------------------------------------------
; Author      Stephan R. W. Lauer, 990224
; ---------------------------------------------------------------------

   switch
        case ((inColorScheme == "topographic") || (inColorScheme == "topo"))
             outColors = ( 0 ~ 140 ~ 240 )
             outColors = outColors | ( 120 ~ 240 ~ 250 )          
             outColors = outColors | ( 0 ~ 250 ~ 40 )          
             outColors = outColors | ( 220 ~ 250 ~ 110 )          
             outColors = outColors | ( 250 ~ 240 ~ 0 )          
             outColors = outColors | ( 240 ~ 170 ~ 50 )          
             outColors = outColors | ( 130 ~ 80 ~ 0 )          
             outColors = outColors | ( 250 ~ 230 ~ 190 )          
             outColors = outColors | ( 230 ~ 230 ~ 230 )          
        break
        case ((inColorScheme == "greyscale") || (inColorScheme == "grey"))
             c = (0:8) * 30
             outColors = ( c ~ c ~ c )
        break 
        default 
             error(1, "grcolorscheme: no such scheme")
   endsw   

endp