proc(dp)=grdotdl(x, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grbar grbox grhist grdot grdotd grash
; -----------------------------------------------------------------------
; Macro        grdotdl
; -----------------------------------------------------------------------
; Description  Generates a dotplot as a density line.
; -----------------------------------------------------------------------
; Usage        bp = grdotdl (x {, col})
; Input
;   Parameter  x 
;   Definition n x 1      vector
;   Parameter  col
;   Definition color
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              bp = grdotdl (t)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a dotplot as a density line
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, dotplot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 961027
; -----------------------------------------------------------------------
  error(cols(x).<>1, "grdot : cols(x)<>1")
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black
  endif  
  d=(max(x)-min(x))./100
  n=rows(x)
  {xb,yb}=bindata(x,d,0)             ; bin data
  sigma=sqrt(cov(x))
  h=2.7772*sigma*n^(-0.2)            ; determine h by rule of thumb
;  wy=symweigh(0,d/h,h/d,"qua")       ; create weights
  g=grid(0,d/h,h/d) 
  m=2^sum((g.<>0),2) 
  w=0.9375.*(1-g^2)^2 
  s=sum((m.*w),1)
  wy=w./s
; end of symweigh
  wx=aseq(0,rows(wy),1)
  {xc,yc,or}=conv(xb,yb,wx,wy)       ; calc density func
  dp = sort((xc+0.5)*d~(yc/(n*h)))
  setmaskp (dp, 0, 0, 0)
  setmaskl (dp, (1:rows(xc))', col, 1, 2) 
endp