proc(pp)=grpcp(x, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grandrews grcontour3 grsunflower
; -----------------------------------------------------------------------
; Macro        grpcp
; -----------------------------------------------------------------------
; Description  Generates a parallel coordinates plot.
; -----------------------------------------------------------------------
; Usage        pp = grpcp (x {, col})
; Input
;   Parameter  x
;   Definition n x p     matrix
;   Parameter  col
;   Definition color
; Output
;   Parameter  pp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;	             x  = read("bank2")
;              z = (x - min(x))./(max(x) - min(x))
;              bp = grpcp (z)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a parallel coordinate plot 
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, parallel cordinate plot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 961017
; -----------------------------------------------------------------------
  if (exist("col").<>1)
    col = 0
  endif
  i  = 0
  n  = rows(x)
  p  = cols(x)  
  while (i.<p)
    i = i+1
    if (i.=1)
      pp = i.*matrix(n)~x[,i]
    else
      pp = pp|(i.*matrix(n)~x[,i])
    endif
  endo
  lt = (1:n)+trans(grid(0, n, p))
  setmaskp (pp, 0, 0, 0)
  setmaskl (pp, lt, col, 1, 2)
endp
