proc(dp)=grppn(x, col)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     grpp grqq grqqu
; -----------------------------------------------------------------------
; Macro        grppn
; -----------------------------------------------------------------------
; Description  generates a probability-probability-plot to compare a 
;              variable with a normal distribution
; -----------------------------------------------------------------------
; Usage        bp = grppn (x{, col})
; Input
;   Parameter  x 
;   Definition n x 1      vector
;   Parameter  col
;   Definition color
; Output
;   Parameter  dp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      ; loads the library graphic
;              library ("graphic")
;              ; generate a dataset with 160 observations
;              t  = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              ; generate a pp-plot to compare t with a normal distribution
;              bp = grqqn (t)
;              ; create a dispplay for plotting
;              d  = createdisplay (1,1)
;              ; plot the pp-plot
;              show (d, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a pp-plot
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
   error(cols(x).<>1, "grppn : cols(x)<>1")
   if (exist("col").<>1)
     grc = getglobal ("grc")  
     col = grc.col.black
   endif
   n  = rows(x)
   q  = ((1:n)-0.5)./n
   z=(x-mean(x))./sqrt(var(x))
   dp = grpp (q,cdfn(z), col)
endp