proc(grout)=grrotate(grin, rot)
; ---------------------------------------------------------------------
; Library     graphic
; ---------------------------------------------------------------------
; See_also    grmove grrot
; ---------------------------------------------------------------------
; Macro       grrotate
; ---------------------------------------------------------------------
; Description Rotates a graphical object by an arbitrary angle
; ---------------------------------------------------------------------
; Usage       grout = grrotate(grin, rot)
; Input       
; Parameter   grin
; Definition  composed graphical object 
; Parameter   rot
; Definition  an angle in radians, scalar
; Output      
; Parameter   grout
; Definition  composed graphical object
; ---------------------------------------------------------------------
; Example     library ("graphic")
;             randomize(101)
;             t = (normal(25)+2)|(normal(25)+2)
;             bp1 = grdot(t)
;             bp2 = grrotate(bp1,  pi/3)
;             setmaskp(bp2, 1) 
;             setmaskp(bp2, 4) 
;             d = createdisplay (1,1)    
;             show (d, 1, 1, bp1, bp2)
; ---------------------------------------------------------------------
; Result      Shows the same dotplot twice, one rotated by 60 degrees.
;             The rotated dotplot is drawn in red.
; ---------------------------------------------------------------------
; Example     library ("graphic")
;             q=0.*matrix(1,36)   ; do not use any facepart
;             q[,1] =1            ; right eye size
;             q[,19]=1            ; left eye size
;             q[,2] =2            ; right pupil size
;             q[,20]=2            ; left pupil size 
;             q[,4] =3            ; right eye slant
;             q[,22]=3            ; left eye slant
;             q[,11]=4            ; right upper hair line
;             q[,29]=4            ; left upper hair line
;             q[,12]=5            ; right lower hairline
;             q[,30]=5            ; left lower hairline
;             q[,13]=6            ; right face line
;             q[,14]=6            ; right darkness of hair
;             q[,31]=6            ; left face line
;             q[,32]=6            ; left darkness of hair
;             h=read("bank2")
;             h=h[101:110,]
;             draw=grface(h,q,5)
;             draw=grrotate(draw,pi/4)
;             d=createdisplay(1,1)
;             axesoff()
;             show(d,1,1,draw)     
;             axeson()
; ---------------------------------------------------------------------
; Result      Shows a Flury-faces plot rotated by 45 degrees, just to
;             demonstrate that any graphical object can be rotated.
; ---------------------------------------------------------------------
; Keywords    graphic primitives
; ---------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; ---------------------------------------------------------------------
; Author      Pavel Cizek, Matthias R. Fengler
; ---------------------------------------------------------------------
;
  grout = grin
;  
  phi = (grout[,1]<0).*(atan(grout[,2]/grout[,1])+pi) + (grout[,1]>0).*atan(grout[,2]/grout[,1]) + ((grout[,1]==0)&&(grout[,2]>0))*(pi/2) + ((grout[,1]==0)&&(grout[,2]<0))*(-pi/2)
  rho = sqrt(grout[,1]^2+grout[,2]^2)
;
  phi = phi + rot
;
  grout[,1]=rho.*cos(phi)
  grout[,2]=rho.*sin(phi)
endp

