proc(r,c,l,d,titl)=gruppenscatter(data,selvar,dcoltype)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista scatter setmaskp showd  
; -----------------------------------------------------------------------
; Macro        gruppenscatter
; -----------------------------------------------------------------------
; Description  creates according the selected variables and group variables
;              the appropriate parameters d, c, r and title to build the 
;              displays in showd for a scatterplot
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter 980616
;------------------------------------------------------------------------
    datah=paf(data.x, data.rowcase&&data.randcase&&data.rowmissing)
    rn=rows(datah)
    layout=3*matrix(rows(datah))
    if(sum(selvar)) 
      datah=(paf(datah',(selvar==1)))'
      colhh=paf(data.colname, selvar)
    else
      colhh=data.colname
    endif 
    p=cols(datah)
    do
      sel1=choosegroup(data,selvar,dcoltype)
    until(sum(sel1).<2)
   ;choose group variable (only one possible), "single"- command
   ;in "selecitemlist" not usable
     r = 0 
     c = 0
     d = 0
     l = list(0)
     titl=" "
      if (sum(sel1)) ;group variable exists?
      sel1 = paf((1:rows(sel1)), sel1) ;extract group variable
      i = 0
      while (i<rows(sel1)) ;loop over group variables
        i   = i+1
        sel = sel1[i]
        ;select first, second,....group variable 
        namegroup=string("Group=%.15s",data.colname[sel])
        colh=data.x[,sel] 
        colh=paf(colh, data.rowcase&&data.randcase)
        ;values of group variable are the different colors
        {g,gind}=groupcol(colh, rn)
        if(max(gind).<7)
          ;group variable only if <7 different values
           if(p==2) ;for only two variables simple plot
              obj=datah[,1]~datah[,2] 
              r=r|1
              c=c|1
              d=d|-1
              setmaskp(obj, gind, layout, 8)        
              append(l, obj)             
              titlstr=colhh[1]+"-"+colhh[2]
              titl=titl|titlstr
            else
              h=0
              while (h.<p) 
              ;loop for X-axis
                h=h+1
                j=0
                while (j.<p)
                ;loop for Y-axis
                  j=j+1
                  if(h==j)
                    obj=colhh[j]|namegroup
                    ;name of variable on diagonal 
                    ;und Gruppe
                    r=r|h
                    c=c|j
                    d=d|-1
                    titl=titl|" "
                    append(l, obj)
                  endif
                  if (h>j)
                    obj=datah[,j]~datah[,h]
                    r = r|h
                    c = c|j
                    d = d|-1         
                    titl=titl|" "
                    setmaskp(obj, gind, layout, 8)        
                    append(l, obj)
                  endif
                endo 
              endo
            endif
          else
          obj="not enough colors"
          ;no computation, error message
            r = r|1 ;only one group variable
            c = c|1      
            d = d|-1   
            titl=titl|" "
           append(l, obj)
        endif
      endo
    else
;scatterplotmatrix without group variable     
      if(p==2) ;for only two variables simple plot
        obj=datah[,1]~datah[,2] 
        r=r|1
        c=c|1
        d=d|-1
        setmaskp(obj, 0, layout, 8)        
        append(l, obj)             
        titlstr=colhh[1]+"-"+colhh[2]
        titl=titl|titlstr
      else
        h=0
        while (h.<p)
        ;loop for X-axis
          h=h+1
          j=0
          while (j.<p)
          ;loop for Y-axis
            j=j+1
            if(h==j)
             obj=colhh[j]
              ;name of variable on diagonal 
              r=r|h
              c=c|j
              d=d|-1
              titl=titl|" "
              append(l, obj)
            endif
            if (h>j)
              obj=datah[,j]~datah[,h]
              r = r|h
              c = c|j
              d = d|-1         
              titl=titl|" "
               setmaskp(obj,0, layout, 8)        
              append(l, obj)
            endif
          endo
        endo   
     endif    
  endif
endp
