proc(xl)=grxline(xpos, height, col)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     gryline grlinreg grcircle
; -----------------------------------------------------------------------
; Macro        grxline
; -----------------------------------------------------------------------
; Description  Generates a vertical line as a graphical object.
; -----------------------------------------------------------------------
; Usage        lx = grxline (x, v {, col})
; Input
;   Parameter  x
;   Definition scalar 
;   Parameter  v
;   Definition n x 1 vector
;   Parameter  col
;   Definition color
; Output
;   Parameter  lx
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Notes        The line is drawn from (x, min(height)) to (x, max(height)).
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              x  = normal(100, 2)
;              lx = grxline (0, x[,2]) 
;              ly = gryline (0, x[,1])
;              d  = createdisplay (1,1)
;              show (d, 1, 1, x, lx, ly)
; -----------------------------------------------------------------------
; Result       shows a bivariate normally distributed dataset and
;              the coordinate axes.
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black
  endif
  ymin = min(height)
  ymax = max(height)
  xl   = #(xpos,xpos)~#(ymin,ymax)
  setmaskp (xl, 0, 0, 0)
  setmaskl (xl, (1:rows(xl))', col, 1, 2)
endp