proc (bn1, bn2) = hardauto (b1, b2, x)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     hardthres softauto softthres
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        hardauto
; -----------------------------------------------------------------------
; Description  Hardthresholds the mother wavelet coefficients b1 and b2 
;              automatically by sqrt(2 sigma n). To compute the 
;              threshold value only b1 and x are used.
; -----------------------------------------------------------------------
; Usage        {bn1, bn2} = hardauto (b1, b2, x)
; Input
;   Parameter  b1
;   Definition n x 3 array,  mother wavelet coefficients
;   Parameter  b2
;   Definition n x 3 array,  mother wavelet coefficients
;   Parameter  x
;   Definition m x 1 array,  input data
; Output
;   Parameter  bn1
;   Definition n x 3 array,  thresholded mother wavelet coefficients
;   Parameter  bn2
;   Definition n x 3 array,  thresholded mother wavelet coefficients
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  n   = rows(x)
  ba  = max(b1[,1])
  bt  = paf(b1[,3], b1[,1].=ba)
  vn  = 2.*sum(bt^2)/n
  ht  = sqrt(2.*vn.*log(rows(b2)))
  bn1 = b1[,1:2]~(b1[,3].*(abs(b1[,3]).>abs(ht)))
  bn2 = b2[,1:2]~(b2[,3].*(abs(b2[,3]).>abs(ht)))
endp
