proc (bhaz,bsurv)=hazbase(data)   
; -----------------------------------------------------------------
; Library     hazreg
; -----------------------------------------------------------------
; See_also    hazdat, hazregll, hazbeta, hazsurv
; -----------------------------------------------------------------
; Macro       hazbase
; -----------------------------------------------------------------
; Description calculates the baseline hazard and survival 
;             function, using the maximum likelihood estimate of 
;             the regression parameter beta obatined through
;             hazbeta. 
; -----------------------------------------------------------------
; Usage       {bhaz, bsurv} = hazbase(data)
; Input
; Parameter   data 
; Definition  n x (p+4) matrix, the first column is the sorted 
;             survival time t, followed by the sorted delta, 
;             inidcating if censoring has occured, labels l, a 
;             column containing the number of ties, and lastly, 
;             the sorted covariate matrix z.
; Output
; Parameter   bhaz  
; Definition  n x 2 matrix, the first column is the sorted 
;             t, followed by the estimated baseline hazard
;             function at the points of t.
; Parameter   bsurv  
; Definition  n x 2 matrix, the first column is the sorted 
;             t, followed by the estimated baseline survival
;             function at the points of t.
; -----------------------------------------------------------------
; Example  library("hazreg") 
;            n = 20
;            p = 2
;            beta = 1|2                      ; regression parameter
;            z = 1 + uniform(n,p)            ; covariates
;            y = -log(1-uniform(n))          ; exponential survival
;            y = y./exp(z*beta)              ; covariate effects
;            c = 4*uniform(n)                ; uniform censoring
;            t = min(y~c,2)                  ; censored time             
;            delta = (y<=c)                  ; censoring indicator            
;            
;         {data,ties} = hazdat(t,delta, z)   ; preparing data
;         {bhaz,bsurv} = hazbase(data)  
;                                            ; estimation of the
;                                            ; baseline hazard and
;                                            ; survival functions                              
; -----------------------------------------------------------------
; Result     The baseline hazard and survival functions are 
;            estimated. 
; -----------------------------------------------------------------
; Keywords   baseline hazard, baseline survival function
; -----------------------------------------------------------------
; Author     Lijian Yang 990706
; -----------------------------------------------------------------
  n=rows(data)

  {betahat,betak,ck} = hazbeta(data)

  p = rows(betahat)
  t = data[,1]
  d = data[,4]

  z = data[,5:p+4]
  zbeta = z*betahat
  ezbeta = exp(zbeta)

  bhaz = matrix(n,1)

  i = 1
  while (i<=n)
    inrisk = hazrisk(data,i)
    inrisk = inrisk'
    bhaz[i] = inrisk*ezbeta
  i = i + 1
  endo
  
  bhaz =  d./bhaz

  i = 2
  while (i<=n)
  bhaz[i] = bhaz[i] + bhaz[i-1]
  i = i + 1
  endo

bsurv = exp(-bhaz)

bhaz = t~bhaz
bsurv = t~bsurv
  
endp


