proc (ll,ll1,ll2)=hazregll(data, beta)   
; -----------------------------------------------------------------
; Library     hazreg
; -----------------------------------------------------------------
; See_also    hazdat, hazbeta
; -----------------------------------------------------------------
; Macro       hazregll
; -----------------------------------------------------------------
; Description calculates derivatives up to order 2 of the 
;             log-likelihood function at parameter value beta
; -----------------------------------------------------------------
; Usage       {ll,ll1,ll2} = hazregll(data, beta)
; Input        
; Parameter   data 
; Definition  n x (p+4) matrix, the first column is the sorted 
;             survival time t, followed by the sorted delta, 
;             inidcating if censoring has occured, labels l, a 
;             column containing the number of ties, and lastly, 
;             the sorted covariate matrix z.
; Parameter   beta 
; Definition  p x 1 vector, the parameter, coefficients of the
;             covariate.
; Output       
; Parameter   ll  
; Definition  scalar, the log-likelihood function at 
;             parameter value beta
; Parameter   ll1  
; Definition  p x 1 vector, the first derivatives at parameter 
;             value beta of the log-likelihood function 
; Parameter   ll2  
; Definition  p x p matrix, negative Hessian matrix at parameter 
;             value beta of the log-likelihood function 
; -----------------------------------------------------------------
; Keywords    log-likelihood, Cox proportional hazards model
; -----------------------------------------------------------------
; Author      Lijian Yang, B. Grund 000217
; -----------------------------------------------------------------
  n=rows(data)

  p = cols(data) - 4		;number of covariates

  error(rows(beta)<>p,"hazregll: number of parameters has to be p")

  delta = data[,2]		;censoring indicator
  z = data[,5:p+4]		;covariate matrix

  zbeta = z*beta
  ezbeta = exp(zbeta)
  ezbeta2 = ezbeta*(ezbeta')
  dezbeta = diag(ezbeta)
  zezbeta = z.*ezbeta


ll =  delta' *zbeta
ll1 = delta' *z
ll2 = 0

  i = 1
  while (i<=n)
   if (delta[i] ==1)
    inrisk = hazrisk(data,i)
    w = inrisk' *ezbeta
    ll = ll - log(w)
    ll1 = ll1 - (inrisk'*zezbeta)./w
    zi  = diag(inrisk) * z
    l2i =  w .*dezbeta - ezbeta2 
    l2i = (zi')*l2i*zi
    l2i = l2i/(w*w)
    ll2 = ll2 + l2i
   endif
  i = i + 1
  endo

ll1 = ll1'
 
endp

