proc()=hazregtest()
; -----------------------------------------------------------------------
; Library      hazreg
; -----------------------------------------------------------------------
; See_also     hazregmain
; -----------------------------------------------------------------------
; Macro        hazregtest
; -----------------------------------------------------------------------
; Description  Tests the quantlets of the hazreg library.
; -----------------------------------------------------------------------
; Usage        hazregtest()         
; -----------------------------------------------------------------------
; Author       Lijian Yang, 990721
; -----------------------------------------------------------------------

library("hazreg") 
      dat=read("haz01.dat")   
      t = dat[,1]                        ; observed times                      
      delta = dat[,2]                    ; censoring indicator                       
      z = dat[,3:4]                      ; covariates  
            
         {data,ties} = hazdat(t,delta, z)   ; preparing data
       
         plot=createdisplay(2,2)
 
             {cil,kme,ciu} = hazkpm(data)
             show(plot,1,1,cil,kme,ciu)     ; Kaplan-Meier estimates
                                            ; with Greenwood confidence
                                            ; bounds plotted
        
             {betahat,betak,ck} = hazbeta(data)
             {bcumhaz,bsurv} = hazcoxb(data)   
             show(plot, 2, 1, bcumhaz)          ; plot baseline hazard
             show(plot, 1, 2, bsurv)            ; plot baseline survival
       
            z1 = 1.1|1.23
            surv = hazsurv(data, z1)
            show(plot, 2, 2, surv)          ; plot conditional survival

         index = 1|0                        ; testing if the second
                                            ; coefficient is zero

         {ttest, val, df, pval} = haztest(data, index)

         val~pval                           ; test statistics and 
                                            ; p-values for the 
                                            ; likelihood ratio, Wald's
                                            ; and scores tests.   

   endp