proc (inrisk)=hazrisk(data,i)   
; -----------------------------------------------------------------
; Library     hazreg
; -----------------------------------------------------------------
; See_also    hazdat, haznar
; -----------------------------------------------------------------
; Macro       hazrisk
; -----------------------------------------------------------------
; Description determines which observations are ar risk at the  
;             time point t_i.
; -----------------------------------------------------------------
; Usage       inrisk = hazrisk(data,i)
; Input
; Parameter   data  
; Definition  n x (p+4) matrix, the first column is the sorted 
;             survival time, followed by the sorted censoring
;             indicator, labels l, a column containing the 
;             number of ties, and lastly, the sorted covariate 
;             matrix z. This data is produced by hazdat.xpl.
; Input
; Parameter   i  
; Definition  an integer between 1 and n.
; Output
; Parameter   inrisk  
; Definition  n x 1 vector, the jth entry is 1 if the jth
;             observation is at risk at time i, 0 otherwise. 
; -----------------------------------------------------------------
; Example    library("hazreg") 
;             
;             y = -log(1-uniform(20))         ; exponential survival
;             c = 2*uniform(20)               ; uniform censoring
;             t = min(y~c,2)                  ; censored time             
;             delta = (y<=c)                  ; censoring indicator            
;             
;             {data,ties} = hazdat(t,delta)   ; preparing data
;             inrisk = hazrisk(data,5)        ; the risk set at 
;                                               observation 5                                
; -----------------------------------------------------------------
; Result      The risk set at observation 5 is listed as a vector   
;             where 1 indicating risk and 0 otherwise. 
; -----------------------------------------------------------------
; Example    library("hazreg") 
;             
;             y = 2|1|3|2|4|7|1|3|2        ; hypothetical survival
;             c = 3|1|5|6|1|6|2|4|5        ; hypothetical censoring
;             t = min(y~c,2)               ; censored time             
;             delta = (y<=c)               ; censoring indicator            
;             
;             {data,ties} = hazdat(t,delta)  ; preparing data 
;             inrisk = hazrisk(data,3)       ;the risk set at observation 3             
; -----------------------------------------------------------------
; Result      The risk set at observation 3 is listed as a vector   
;             where 1 indicating risk and 0 otherwise. 
; -----------------------------------------------------------------
; Keywords    number at risk, survival time, censored data
; -----------------------------------------------------------------
; Author      Lijian Yang 990601
; -----------------------------------------------------------------
  t  = data[,1]
  ;label = data[,3]
  ;data = label~t
  ;data = sort(data,1)
  ;inrisk = data[,2]
  inrisk = t
  ti = inrisk[i] 
  inrisk = (inrisk>=ti)
  
endp


