proc(h)=hgen(ord,di)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  agen, bgen
; ----------------------------------------------------------------------
;   Macro	  hgen
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for full VAR model analysis
; ----------------------------------------------------------------------
;   Usage         h = hgen(ord,di)
;   Input 
;     Parameter   ord 
;     Definition    vector, order of series
;     Parameter   di 
;     Definition    vector, dimensions
;   Output
;     Parameter   h
;     Definition    vector
; ----------------------------------------------------------------------
;   Example       library("multi")
;		  h = hgen(2,2)
;                 h
; ----------------------------------------------------------------------
;   Result        Contents of h
;                 [1,]        1        0
;                 [2,]        0        1  
;                 [3,]        0        0 
;                 [4,]        0        0 
;                 [5,]        1        0 
;                 [6,]        0        1 
;                 [7,]        0        0 
;                 [8,]        0        0 
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich  971027
; ---------------------------------------------------------------------- 
if (ord==1)
   h=eye(di)|eye(di)
else
   h=eye(di)|zeros(di*(ord-1),di)
   h=h|h
endif
endp;
