proc(t,p,ti,cv2)=hhmult(vhat,y,yhat,h)
;------------------------------------------------------------------------
; Library       metrics
;------------------------------------------------------------------------
; See_also      hhtest  glmmultlo  genmultlo
;------------------------------------------------------------------------
; Macro         hhmult
;------------------------------------------------------------------------
; Keywords      specification test, polychotomous response model, 
;		conditional logit model, the multinomial logit model
; -----------------------------------------------------------------
; Description   hhmult calculates the H-H statistic to jointly test the specification 
;               of the link functions of a polychotomous response model 
;               (such as the conditional logit model or the multinomial 
;               logit model)  
; ----------------------------------------------------------------------- 
; Reference     Werwatz (1997), "A consistent test for misspecification in 
;		polychotomous response models", Discussion Paper No. 97-74, 
;		SFB 373, HU Berlin
; -----------------------------------------------------------------
; Usage         {t,p} = hhmult (vhat,y,yhat,h)                  
;------------------------------------------------------------------------
; Input                                                                     
; Parameter     vhat  
; Definition            n x M  matrix containing the projected indices
; Parameter     y
; Definition            n x M  matrix containing n observ. of M binary dependent variables                                      
; Parameter     yhat  
; Definition            n x M  matrix with the predicted probabilities P(Y_m=1|x)
; Parameter     h     
; Definition    1 x M  vector of bandwidths        
; Output                                                                     
; Parameter     t     
; Definition            scalar,   the value of the test statistic                      
; Parameter     p     
; Definition            scalar,   the p-value of t, i.e. 1 - cdfc(t,M)                         
; ------------------------------------------------------------------------
;  Example      
;               library("glm") 
;               library("metrics") 
;               n = 100
;               b = (1|2)~(-1|0)~(1|1)
;               x = normal(n,rows(b))
;               y = genmultlo(x,b)
;               ml = glmmultlo(x,y)
;               vhat=   x*ml.b
;               y1   =  y.=1
;               y2   =  y.=2
;               y3   =  y.=3
;               y   =   y1~y2~y3
;               c1  =   cols(vhat)
;               h   =   matrix(c1)' 
;               yhat=   ml.mu
;              {t,p}=   hhmult(vhat,y,yhat,h)
;               t~p
;-------------------------------------------------------------------------
;   Result    test statistic, t, and p-value, p.
; -----------------------------------------------------------------
; Author        AKW,960916 
; ----------------------------------------------------------------------------
        c1  =   cols(vhat)
        c2  =   cols(y)
        Ck  =   5/7
        n   =   rows(y)
        res =   y - yhat
        xs  =   sort(vhat~res~y~matrix(n))
        mh  =   sker(xs[,1:c1],h,"qua",xs[,(c1+1):cols(xs)])
        mh  =   (n*prod(h'))*mh-0.9375^c1.*xs[,(c1+1):cols(xs)]
        test3=   sum(mh[,1:c2])
        ti  =   1/(n*prod(h')^(c2/2))* sum(xs[,(c1+1):(c1+c2)].*mh[,1:c2])
        den =   mh[,2*c2+1]+1e-10
        s0  =   mh[,(c2+1):(2*c2)]./den
        s   =   2/n*(Ck)^c1*sum(s0^2.*(1-s0)^2.*(1/(n*prod(h')^c1).*den))       
        cv0 =   (mh[,(c2+1):(2*c2)]./den)^2
        cv1 =   2/n*(Ck)^c1*cv0'*(cv0.*(1/(n*prod(h')^c1).*den))
        cv2 =   matrix(c1,c1)+diag((-1)*matrix(c1))
        cv2 =   cv2.*cv1
        cv2 =   cv2+diag(s')
        t   =   ti*inv(cv2)*ti'
        p   =   1-cdfc(t,c2)
        endp
