proc (y)=highgau(x, q)
; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     highepa
; -----------------------------------------------------------------
;   Macro       highgau
; -----------------------------------------------------------------
;   Description  highgau computes the multivariate higher order 
;                kernel derived from the gaussian kernel 
; -----------------------------------------------------------------
;   Usage        y = highgau(x, {q})
;   Input
;     Parameter  x  
;     Definition n x p matrix
;     Parameter  {q}  
;     Definition order of the kernel, default is 2, can be 4, 6, 8
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-4, 81, 0.1) 
;             y = highgau(x,6) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author    Lijian Yang, 970719  
; -----------------------------------------------------------------
if (exist(q)==0)    
    q=2                                      
endif   
if (q==2)
   y=prod(pdfn(x),2)
endif
if (q==4)
   y=prod((3-x.^2)./2.*pdfn(x),2)
endif
if (q==6)
   y=prod((15-10.*x.^2+x.^4)./8.*pdfn(x),2)
endif
if (q==8)
   y=prod((105-105.*x.^2+21.*x.^4-x.^6)./48.*pdfn(x),2)
endif
endp
