proc (r) = hillgp1diag (x, k)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      hillgp1
; -----------------------------------------------------------------
;   Macro         hillgp1diag
; -----------------------------------------------------------------
;   Description   Vector of Hill estimator for GP1 model
; -----------------------------------------------------------------
;   Usage         r = hillgp1diag (x, k)
;   Input
;     Parameter   x
;     Definition      vector
;     Parameter   k
;     Definition      vector, number of exceedances
;   Output
;     Parameter   r
;     Definition      vector with shape parameters
; -----------------------------------------------------------------
;   Example   library("finance")
;	      x=randx("gp1",100,1)
;             r=hillgp1diag(x,2:100)
; -----------------------------------------------------------------
;   Result    Vector with estimated shape parameter for all number of
;             extremes provided in k
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  x = log (sort (paf (x, x > 0)))
  x = x [rows (x) : 1]
  n = rows (x)
  r = (1 / ((cumsum (x) [1:n-1]) / (1:n-1) - x[2:n]))[k - 1]
endp
