proc (ind)=indexfriedmantukey(px, h)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plotgt indexentropy indexlegendre indexhermite indexnaturalhermite
; -----------------------------------------------------------------------
; Macro        indexfriedmantukey
; -----------------------------------------------------------------------
; Description  computes the Friedman Tukey index via kernel density
;              estimation
; -----------------------------------------------------------------------
; Usage        ind = indexfriedmantukey (x, h)
; Input
;   Parameter  px
;   Definition n x p matrix
;   Parameter  h
;   Definition 1 x p matrix bandwidth
; Output
;   Parameter  ind
;   Definition scalar
; -----------------------------------------------------------------------
; Note         If in the computation of the index occur terms which are
;              constant independently of the projection then we omit
;              these terms
; -----------------------------------------------------------------------
; Example      ; loads the library pp
;              library ("pp")
;              ; initialize random generator
;              randomize(0)
;              ; generate a dataset with mean(x)=0 and cov(x)=I_2
;              x = normal(922,2)             
;              ; compute the index with rule-of-thumb bandwidth
;              indexfriedmantukey(x, 1~1)
; -----------------------------------------------------------------------
; Result       Content of object ind
;              [1,] 0.000029
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971113
; -----------------------------------------------------------------------
  f    = sker (px, h, "qua", matrix(rows(px)))
  ind  = mean(f)
endp