proc (ind)=indexlegendre(px, h)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plotgt indexfriedmantukey indexentropy indexhermite indexnaturalhermite
; -----------------------------------------------------------------------
; Macro        indexlegendre
; -----------------------------------------------------------------------
; Description  computes the Legendre index via kernel density
;              estimation
; -----------------------------------------------------------------------
; Usage        ind = indexlegendre (x, h)
; Input
;   Parameter  px
;   Definition n x p matrix
;   Parameter  h
;   Definition 1 x p matrix bandwidth
; Output
;   Parameter  ind
;   Definition scalar
; -----------------------------------------------------------------------
; Note         If in the computation of the index occur terms which are
;              constant independently of the projection then we omit
;              these terms
; -----------------------------------------------------------------------
; Example      ; loads the library pp
;              library ("pp")
;              ; initialize random generator
;              randomize(0)
;              ; generate a dataset with mean(x)=0 and cov(x)=I_2
;              x = normal(922,2)             
;              ; compute the index with rule-of-thumb bandwidth
;              indexlegendre(x, 1~1)
; -----------------------------------------------------------------------
; Result       Content of object ind
;              [1,] 0.000029
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971113
; -----------------------------------------------------------------------
  f    = sker (px, h, "qua", matrix(rows(px)))
  ind  = mean (f./prod(pdfn(px), 2))
endp