proc(gest)=intest(t,y,h,g,loc,opt)   
; -----------------------------------------------------------------
; Library  	  gam
; -----------------------------------------------------------------
;  See_also       intestpl, gintest, gintestpl, pcad, gamfit
; -----------------------------------------------------------------
;   Macro         intest
; -----------------------------------------------------------------
;   Description   estimation of the univariate additive functions
;                 in a separable additive model using Nad.Watson,
;                 local linear or local quadratic
; -----------------------------------------------------------------
;   Usage         gest = intest(t,y,h,g,loc{,opt})    
;   Input
;     Parameter   t  
;     Definition      n x p matrix , the observed explanatory variable 
;                     where the directions of interest have to be the 
;                     first p columns 
;     Parameter   y 
;     Definition      n x q matrix , the observed 
;                     response variables
;     Parameter   h  
;     Definition      p(pg) x 1 or 1 x 1 matrix , chosen bandwidth for 
;                     the directions of interest         
;     Parameter   g  
;     Definition      p x 1 or 1 x 1 matrix , chosen bandwidth for 
;                     the directions not of interest       
;     Parameter   loc  
;     Definition      dummy, for loc=0 local constant (Nad. Wats.),
;                     for loc=1 local linear and for loc=2 local
;                     quadratic estimator will be used
;     Parameter   opt.tg  
;     Definition      ng x pg vector, a grid for continuous part. If tg is
;                     given, the nonparametric function will be 
;                     computed on this grid.
;     Parameter   opt.shf  
;     Definition      integer,  (show-how-far) if exists and =1, an output
;                     is produced which indicates how the iteration
;                     is going on (additive function / point of estimation /
;                     number of iteration).
;   Output                        
;     Parameter   gest 
;     Definition      n(ng) x pp x q matrix, containing the marginal
;                     integration estimates of the additive components
;                     in the first p columns, the derivatives in the 
;                     followings, so pp = pg*(loc+1)
; -----------------------------------------------------------------
;   Example   library("gam")
;             randomize(1234)
;             t     = uniform(50,2)*2-1
;             g1    = 2*t[,1]
;             g2    = t[,2]^2 
;             g2    = g2 - mean(g2)
;             y     = g1 + g2  + normal(50,1) * sqrt(0.25)
;             h     = #(1.2, 1.0)          
;             g     = #(1.4, 1.2)     
;             loc   = 1
;             gest  = intest(t,y,h,g,loc)
;             gest
;             bild  = createdisplay(1,2)
;             dat11 = t[,1]~g1
;             dat12 = t[,1]~gest[,1]
;             dat21 = t[,2]~g2
;             dat22 = t[,2]~gest[,2]
;             setmaskp(dat12,4,4,8)
;             setmaskp(dat22,4,4,8)
;             show(bild,1,1,dat11,dat12)
;             show(bild,1,2,dat21,dat22)
; -----------------------------------------------------------------
;   Result    the marginal integration estimates of the additive 
;             functions and its derivatives, using local polynomials,
;             see Severance-Lossin & Sperlich (1995)
; -----------------------------------------------------------------
;   Author    Sperlich & Stockmeyer  970509 
; -----------------------------------------------------------------
 if (comp("opt","shf")>0)
   shf = opt.shf
 else
   shf = 0
 endif
 if (comp("opt","tg")<1)
   tg = t
 else
   tg = opt.tg
 endif
 p = cols(t)
 n = rows(t)
 q = cols(y)
 pg = cols(tg)
 ng = rows(tg)
 o = sort(t[,1]~(1:n))[,2]
 ys = y[o]
 ts = t[o]
 error(sum(loc==#(0,1,2))!=1,"loc is not correctly specified")
 if (rows(g)<>p)             /* reshape g to matrix */
   errtext = "rows of g didn't fit: "+string("%1.1f",p)+" assumed"
   warning(rows(g)>1,errtext)
   g = matrix(p)*g[1,1]  
 endif 
 if (rows(h)<>pg)            /* reshape h to matrix */
   errtext = "rows of h didn't fit: "+string("%1.1f",pg)+" assumed"
   warning(rows(h)>1,errtext)
   h = matrix(pg)*h[1,1]
 endif
 j = 1
 if (loc==0)
   gest = matrix(ng,pg,q)
   ys = ys~matrix(n)               
   while (j.<=pg)
     m = 1
     hs = g
     hs[j] = h[j]
     while (m<=ng)
       if (shf)
         ("intest: "+string("%1.0f",j)+" "+string("%1.0f",m))
       endif
       test = ts
       test[,j] = tg[m,j]*matrix(n)
       r = sker(ts,hs',"qua",ys,test)
       r = paf(r,r[,q+1].<>0)
       mh = r[,1:q]./r[,q+1]
       gest[m,j,] = mean(mh,1)
       m = m + 1
     endo   
     j = j + 1
   endo
   ys = ys[,1:q] 
 else
   loc = loc-1               /* needed for locpoldis, loch */
   gest = matrix(ng,(2+loc)*pg,q)*0
   while (j.<=pg)
     hs = g
     hs[j] = h[j]
     if (loc)
       posgest = j | (pg+j) | (2*pg+j)
       posmb = 1 | (1+j) | (1+p+j)
     else
       posgest = j | (pg+j)
       posmb = 1 | (1+j)
     endif
     m = 1 
     while (m.<=ng)
       if (shf)
         ("intest: "+string("%1.0f",j)+" "+string("%1.0f",m))
       endif
       test = ts
       test[,j] = tg[m,j]*matrix(n)
       ma = locpoldis(ts,test,ys,hs,loc)
       k = 1
       while (k<=q)
         sel = isNumber(ma[,1,k])  
         if (sum(sel,1)>10)
           mb = paf(ma[,,k],sel)
         else
           mb = ma[,,k]
         endif
         gest[m,posgest,k] = mean(mb[,posmb],1)
         k = k+1
       endo
       m = m+1
     endo   
   j = j+1
   endo
   if (loc)
     gest[,(2*pg+1):(3*pg),] = gest[,(2*pg+1):(3*pg),]*2 
   endif
 endif
 reshape("ys",#(n,1,q))
 gest[,1:pg,] = gest[,1:pg,].- mean(y,1)
endp
