proc(gest)=intest1(x,y,xg,h,g)
; -----------------------------------------------------------------
; Library     gam
; -----------------------------------------------------------------
;  See_also       intest, pcad
; -----------------------------------------------------------------
;   Macro         intest1
; -----------------------------------------------------------------
;   Description   estimation of the univariate additive functions
;                 in a separable additive model using Nad.Wat.
; -----------------------------------------------------------------
;   Usage         gest = intest1(x,y,xg,h,g)
;   Input
;     Parameter   x
;     Definition      n x d matrix , the observed explanatory variable
;                     where the directions of interest have to be the
;                     first q columns
;     Parameter   y
;     Definition      n x p matrix , the observed response variables
;     Parameter   xg
;     Definition      m x q matrix , the grid with m points in each
;                     of the q directions of interest
;     Parameter   h
;     Definition      q x 1 or 1 x 1 matrix , chosen bandwidth for
;                     the directions of interest
;     Parameter   g
;     Definition      d x 1 or 1 x 1 matrix , chosen bandwidth for
;                     the directions not of interest
;   Output
;     Parameter   gest
;     Definition      m x q x p matrix, containing the marginal
;                     integration estimators
; -----------------------------------------------------------------
;   Example   library("gam")
;             n     = 150
;             x     = uniform(n,4)*4-2
;             g1    = 2*x[,1]
;             g2    = x[,2]^2 - 4/3
;             g3    = exp(x[,3])
;             g4    = sin(1.5*x[,4])
;             eps   = normal(n,1) * sqrt(0.5)
;             y     = g1 + g2 + g3 + g4 + eps
;             xg    = grid(-1.8,0.2,19)
;             xg    = xg~xg
;             h     = #(1.0, 0.75)            ; we are interested in
;             g     = #(1.3, 1.0, 1.5, 1.5)   ; the shape of g1, g2
;             gest  = intest1(x,y,xg,h,g)
;             bild  = createdisplay(1,2)
;             dat11 = x[,1]~g1
;             dat12 = xg[,1]~gest[,1]
;             dat21 = x[,2]~g2
;             dat22 = xg[,2]~gest[,2]
;             setmaskp(dat12,4,4,8)
;             setmaskp(dat22,4,4,8)
;             setmaskl(dat12,(1:rows(dat12))',4,1,1)
;             setmaskl(dat22,(1:rows(dat22))',4,1,1)
;             show(bild,1,1,dat11,dat12)
;             show(bild,1,2,dat21,dat22)
; -----------------------------------------------------------------
;   Result    the marginal integration estimator of the additive
;             functions, using a multidimensional Nadaraya Watson
;             see Tjostheim and Auestad, "Nonparametric Identifi-
;             cation of Nonlinear Time Series: Projections", JASA,
;             (1994)
; -----------------------------------------------------------------
;   Author    Korndoerfer & Sperlich  960805
; -----------------------------------------------------------------
 Jmax = cols(xg)
 Mmax = rows(xg)
 d = cols(x)
 n = rows(x)
 p = cols(y)
 xs = sort(x~y)
 ys = xs[,d+1:d+p]~matrix(n)
 xs = xs[,1:d]
 gest = matrix(Mmax,Jmax,p)
 if (rows(g)<>d)             ; reshape g to matrix
   error(rows(g)>1,"rows of g do not fit")
   g = matrix(d)*g
 endif
 if (rows(h)<>Jmax)          ; reshape h to matrix
   error(rows(h)>1,"rows of h do not fit")
   h = matrix(Jmax)*h
 endif
 j = 1
   while (j.<= Jmax)
      m = 1
      hs = g
      hs[j] = h[j]
      while (m.<= Mmax)
        xest     = xs
        xest[,j] = xg[m,j]*matrix(n)
        xest = sort(xest)
        r = sker(xs, hs', "qua", ys, xest)
        r = paf(r,r[,p+1].<>0)
        mh = r[,1:p]./r[,p+1]
        gest[m,j,] = mean(mh,1)
        m = m + 1
      endo
      j = j + 1
   endo
 reshape("y",#(n,1,p))
 gest = gest .- mean(y,1)
endp
