proc (y) = isNaN (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      countNaN countNotNumber isInf isNumber
; -----------------------------------------------------------------
;  Keywords      missing values
; -----------------------------------------------------------------
;   Macro        isNaN
; -----------------------------------------------------------------
;   Description  Determines whether elements of an array are
;                missing values (NaN).
; -----------------------------------------------------------------
;   Usage        y = isNaN (x)
;   Input
;     Parameter  x  
;     Definition array
;   Output
;     Parameter  y  
;     Definition array with 1 (true, is NaN) or 0 (false)
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x = #(0/0, 1/0, -1/0, 1)
;             x ~ isNaN (x)
; -----------------------------------------------------------------
;   Result    
;             Contents of _tmp
;	      [1,]   NaN     1 
;	      [2,]   Inf     0 
;	      [3,]  -Inf     0 
;	      [4,]     1     0 
; -----------------------------------------------------------------
;   Author    TTK, 960423
; -----------------------------------------------------------------

  y = !(x <= Inf)       ; each number is <= infinity except NaN
endp

