proc(output,betase,betastan,pval,MSSR)=istaanova(x,y,colhx,beta,int)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istalinreg regressionselction 
; -----------------------------------------------------------------------
; Macro        istaanova
; -----------------------------------------------------------------------
; Description  show the ANOVA table after performing a linear regression
;              with Enter method for variable inclusion
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Susanne Hannappel   961122 Kerstin Zanter   980616
;------------------------------------------------------------------------
//ANOVA table
		
	yhat=x*beta
	ybar=mean(y)
	
	if (abs(int-1)<0.001)//with intercept
 		dfM=rows(beta)-1	
	else
		dfM=rows(beta)	
	endif
	 
	dfMstr=string("%6.0f",dfM)
	SSM= sum((yhat .-ybar).*(yhat .-ybar))
	SSMstr=string("%10.3f",SSM)
	MSSM=SSM/dfM
	MSSMstr=string("%10.3f",MSSM)
	
	dfR=rows(x)-1-dfM
	dfRstr=string("%6.0f",dfR)
	SSR= sum ((yhat - y).*(yhat - y))
	SSRstr=string("%10.3f",SSR)
	MSSR=SSR/dfR
	MSSRstr=string("%10.3f",MSSR)
		
	dfT=rows(x)-1
	dfTstr=string("%6.0f",dfT)
	SST= sum ((y - ybar).*(y - ybar))
	SSTstr=string("%10.3f",SST)
	MSST=SST/dfT
	MSSTstr=string("%10.3f",MSST)
	
	Fvalue=(SSM * dfR)/(SSR * dfM)
	Fvalstr=string("  %10.3f", Fvalue)
	FPvalue=1-cdff(Fvalue,dfM,dfR)
	FPvalstr=string("   %1.4f", FPvalue)
	
	MultipR= sqrt(SSM/SST)
	MultipRstr=string("Multiple R      = %7.5f",MultipR)
	Rsquare= SSM/SST
	Rstr=string("R^2             = %7.5f",Rsquare)
	adRsquare= 1-((dfT*SSR)/(dfR*SST))
	adRstr=string("Adjusted R^2    = %7.5f",adRsquare)
	StanEr= sqrt((sum((y-yhat).*(y-yhat))/dfR))
	StanErstr=string("Standard Error  = %7.5f",StanEr)
//PARAMETERS with t-test
	
	ttestmatrix=(inv(x'*x))	
	diagttestmatrix=xdiag(ttestmatrix)
	betase=sqrt(MSSR*diagttestmatrix)
	betasestr=string("     %8.4f",betase)
	xbar=mean(x)
	xstddev=sqrt(sum((x.-xbar).*(x.-xbar)))	
	ystddev=sqrt(sum((y-ybar).*(y-ybar)))	
	sksy=trans(xstddev./ystddev)	
	betastan=beta.*sksy
	betastanstr=string("     %8.4f",betastan)
	tvalues=beta./(sqrt(MSSR*diagttestmatrix))
	tvalstr=string("  %12.3f", tvalues) 
	 
	tPvalues=2*(1-cdft(abs(tvalues),dfR))
	pval=tPvalues
	tPvalstr=string("   %1.4f", tPvalues)
	if (abs(int-1)<0.001)//with intercept
 		colhxstr="Constant"|colhx
    betastr=string("b[%2.0f,]= %15.4f", 0:(rows(beta)-1), beta)	
	else
	  colhxstr=colhx
    betastr=string("b[%2.0f,]= %15.4f", 1:rows(beta), beta)	
	endif
//TEXTOUTPUT	
	 
	anfirstline= "A  N  O  V  A                   SS      df     MSS       F-test   P-value"
	ansecondline="_________________________________________________________________________"
	anovatextMod= "Regression                "+SSMstr+dfMstr+MSSMstr+Fvalstr+FPvalstr
	anovatextRes= "Residuals                 "+SSRstr+dfRstr+MSSRstr
	anovatextTot= "Total Variation           "+SSTstr+dfTstr+MSSTstr	
	anovatext=""|anfirstline|ansecondline|anovatextMod|anovatextRes|anovatextTot|""|MultipRstr|Rstr|adRstr|StanErstr
	
	parfirstline="PARAMETERS         Beta         SE         StandB        t-test   P-value  Variable"    
	parsecondline="___________________________________________________________________________________"
	parametertext=""| parfirstline|parsecondline|betastr+betasestr+betastanstr+tvalstr+tPvalstr+"   "+colhxstr
	output= anovatext|""|parametertext
endp