proc(j)=jagen(di, ord,typ)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  agen
; ----------------------------------------------------------------------
;   Macro	  jagen
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for VAR models
; ----------------------------------------------------------------------
;   Usage         j = jagen(di, ord,typ)
;   Input 
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   typ 
;     Definition     integer, describing the model type
;   Output
;     Parameter   j
;     Definition     matrix
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich 971106
; ----------------------------------------------------------------------
if (typ==6)      ; 1
   if (ord==1)       ; 2
     j=eye(di)~zeros(di,di)
   else              ; 2
     if (ord>=2)         ; 3 
       j=eye(di)~zeros(di,(2*ord-1)*di)
     else                ; 3
       j=0
     endif              ; 3
   endif            ; 2
else             ; 1
   if (ord==1)
     j=eye(di)
   else
     if (ord>=2) 
       j=eye(di)~zeros(di,di*(ord-1))
     else
       j=0
     endif
   endif
endif           ; 1
endp
