proc(EmitedSerie)=kemitor(T,x0,H,F,ErrY,ErrX)

; -----------------------------------------------------------------
; Library        times
; -----------------------------------------------------------------
;  See_also      kfilter, ksmoother, kem
; -----------------------------------------------------------------
;   Macro        kemitor
; -----------------------------------------------------------------
;   Description  Calculates observations of a given state-space
;                model.
The state-space model is assumed to be
;                in the
following form:
;
;                y_t = H x_t + ErrY_t
;
;                x_t = F x_t-1 + ErrX_t
;
;                x_0 = mu
;
; -----------------------------------------------------------------
;   Keywords     state-space models
; -----------------------------------------------------------------
;   Usage         y = kemitor(T,mu,H,F,ErrY,ErrX)    
;   Input
;     Parameter   T   
;     Definition      number of observations to be generated
;     Parameter   mu
;     Definition      n x 1 vector (starting point of the model)
;     Parameter   H    
;     Definition      m x n matrix
;     Parameter   F    
;     Definition      n x n matrix
;     Parameter   ErrY   
;     Definition      T x m matrix
of errors
;     Parameter   ErrX
;     Definition      T x n matrix
of errors 
;   Output                                                           
;     Parameter   y  
;     Definition      T x m matrix of generated time series, 
;                     T is the number of generated observations,
;                     m is the dimension of generated time series
; -----------------------------------------------------------------
;   Example   library("xplore")
;             library("plot")
;             library("times")
;             randomize(0)
;             T = 100
;             mu = 10
;             H = 1
;             F = 1
;             ErrY = normal(T) .* 3
;             ErrX = normal(T) .* 3
;             rw = kemitor(T,mu,H,F,ErrY,ErrX)
;
;             rw = vec(1:T)~rw
;             rw = setmask(rw,"line", "blue", "thin")
;             disp = createdisplay(1,1)
;             show(disp,1,1,rw)
; -----------------------------------------------------------------
;   Result    Generates a random walk with errors.
; -----------------------------------------------------------------
;   Example   library("xplore")
;             library("plot")
;             library("times")

;             randomize(0)
;             T = 100
;             ErrX = normal(T)~(vec(1:T).*0)
;             ErrY = normal(T).*2
;             H = 1~0 
;             F = #(0.5,1)~#(-0.3,0)
;             x0 = #(0,0)
;             ar2 = kemitor(T,x0,H,F,ErrY,ErrX)
;
;             ar2 = vec(1:T)~ar2
;             ar2 = setmask(ar2,"line", "blue", "thin")
;             disp = createdisplay(1,1)
;             show(disp,1,1,ar2)
; -----------------------------------------------------------------
;   Result    Generates an AR(2) with additive gaussian errors.
; -----------------------------------------------------------------
;   Example   library("xplore")
;             library("plot")
;             library("times")

;             randomize(0)
;             T = 100
;             mu = #(20,0)
;             H  = #(0.3,-0.3)~#(1,1)
;             F  = #(1,0)~#(1,0)
;             ErrY = (normal(T) .* 3)~(normal(T) .* 3)
;             ErrX  = (normal(T) .* 0)~(normal(T) .* 3)
;             ser = kemitor(T,mu,H,F,ErrY,ErrX)
;             ser = vec(1:T)~ser
;
;             ser1 = ser[,1]~ser[,2]
;             ser2 = ser[,1]~ser[,3]
;             ser1 = setmask(ser1,"line", "blue", "thin")
;             ser2 = setmask(ser2,"line", "blue", "thin")
;             disp = createdisplay(2,1)
;             show(disp,1,1,ser1)
;             show(disp,2,1,ser2)
; -----------------------------------------------------------------
;   Result    Generates 100 observations of a given state space 
;             model.
; -----------------------------------------------------------------
;   Author    P.Franek 990507
; -----------------------------------------------------------------


; dimensions check
  
  error(cols(F) <> rows(F), "Matrix F is not square.")
  error(cols(F) <> rows(x0), "Matrix F and x0 dim mismatch.")
  error(cols(H)<>rows(x0),"Matrix H and x0 dim mismatch.")
  error(cols(ErrX)<>rows(x0),"x-errors and x0 dim mismatch.")
  error(rows(H)<>cols(ErrY),"Matrix H and y-errors dim mismatch.")
  warning(rows(ErrX) <> rows(ErrY), "Different number of x- and y-errors.")
  warning(rows(ErrX) <> T, "Number of x-errors different from number of observations.")
  warning(rows(ErrY) <> T, "Number of y-errors different from number of observations.")


  PomX = F * x0   + ErrX[1,]'
  PomY = H * PomX + ErrY[1,]'          ; starting x and y 
  
  EmitedSerie = PomY                   ; resulting serie
  
  i = 2
  PrevPomX = PomX
  while (i <= T)
    PomX = F * PrevPomX + ErrX[i,]'
    PomY = H * PomX     + ErrY[i,]'
    PrevPomX = PomX
    EmitedSerie = EmitedSerie~PomY  
    i = i+1
  endo
  
  EmitedSerie = EmitedSerie'
  
endp
