proc (y) = kron (a, b)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      *
; -----------------------------------------------------------------
;  Keywords     Kronecker product, matrix manipulation
; -----------------------------------------------------------------
;   Macro        kron
; -----------------------------------------------------------------
;   Description  Computes the Kronecker product of two matrices.
; -----------------------------------------------------------------
;   Usage        y = kron (a, b)
;   Input
;     Parameter  a
;     Definition array
;     Parameter  b
;     Definition array
;   Output
;     Parameter  y  
;     Definition array
; -----------------------------------------------------------------
;   Example   library("xplore")
;             a = 1:3
;             b = reshape (1:4,#(2,2))
;             kron (a, b)
; -----------------------------------------------------------------
;   Result
;             Contents oy y
;             [1,]        1        3 
;             [2,]        2        4 
;             [3,]        2        6 
;             [4,]        4        8 
;             [5,]        3        9 
;             [6,]        6       12 
; -----------------------------------------------------------------
;   Author    TTK, 970123
; -----------------------------------------------------------------

  m = rows (a)
  n = cols (a)
  p = rows (b)
  q = cols (b)
  y = reshape(a,1|m|1|n).*reshape(b,p|1|q)
  y = reshape (y, m*p|n*q)

endp

