proc (k) = kurtosis (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      skewness kurtosis
; -----------------------------------------------------------------
;  Keywords      moments, kurtosis, excess
; -----------------------------------------------------------------
;   Macro        kurtosis
; -----------------------------------------------------------------
;   Description  Computes the kurtosis for a given vector.
; -----------------------------------------------------------------
;   Usage        k = kurtosis (x)
;   Input
;     Parameter  x  
;     Definition   vector
;   Output
;     Parameter  k
;     Definition   scalar
; -----------------------------------------------------------------
;   Example   library("xplore")
;             randomize (0)
;             x = normal (100)
;             kurtosis (x)
; -----------------------------------------------------------------
;   Result    
;             Contents of k
;             [1,] 3.2794
; -----------------------------------------------------------------
;   Author    TTK, 960207; Marlene Mueller 990308
; -----------------------------------------------------------------
  k  = mean ((x-mean(x))^4) ./ (var(x)^2)
endp

