proc()=modelfr(typ,ytt,header,outp,y)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     domulti 
; -----------------------------------------------------------------
;   Macro        modelfr
; -----------------------------------------------------------------
;   Description  general analysis for the Full VAR Model, called
;                by the quantlet domulti
; -----------------------------------------------------------------
;   Usage        modelfr(typ,ytt,header,outp,y)  
;   Input
;     Parameter   typ  
;     Definition      1,2 or 3, giving the type of model: 1=Full,
;                     2=Subset, 3=Reduced Rank
;     Parameter   ytt 
;     Definition      k x n matrix, the transformed (and transposed) 
;                     time series  
;     Parameter   header
;     Definition      list of 7 objects:   natlog,diff,origyear,
;                     periodicity,origperiod,name,exclude
;     Parameter   outp
;     Definition      integer, (1=output to file, 0 = no output)
;     Parameter   y 
;     Definition      k x n matrix, the original time series
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich 971010, CH 981230
; -----------------------------------------------------------------
  di=rows(ytt)
  diff=header[2]
  infotran=(1:di) ~ (header.diff*2-1) ~ (header.natlog*2-1)
  sel="Order"|"Mean adjusted (No=0, Yes=1)"|"Beginning of sample"|"End of sample"
  r=readvalue(sel,2|0|5|cols(ytt))
  ord=r[1]
  adj=r[2]
  tb=r[3]
  te=r[4]
  t=te-tb+1
  error(tb-ord<1, "Check beginning of sample!")
  b=coeffest(ord,di,tb,te,adj,typ,ytt);
  b2=b;
  bbig=aorBgen(b,di,ord,adj,typ);
  jota=jotaAorB(di,ord,adj,typ);
  covu=covres(ord,di,tb,te,adj,typ,ytt);
  ok=covcheck(covu);
  if (ok==1)
    sfvonb=sfcoeff(ord,di,tb,te,adj,typ,ytt);
    sfb2=sfvonb;
    gam=zmulz(ord,di,tb,te,adj,0,typ,ytt)/t;
    if (adj==1)
      sfb2=sfvonmw(b,covu,di,ord,t);
      b2=mean(ytt[,tb:te]')';
      if (ord.>0)
        sfb2=sfb2~sfvonb;
        b2=b2~b;
      endif;
    endif;
  endif;
    if (ok==1)
     headline=" Menu: Results of Full VAR estimation" 
     items=" VAR order criteria" | " Coefficients (standard errors)" | " Coefficients (t-ratios)"  
     items = items | " Covariance Matrix of Residuals" | " Residual Analysis"
     items = items | " Test for structural break" | " Structural Analysis" | " Forecasting"
     items = items | " Quit to main menu"
     do
     is=selectitem(headline, items,"single") 
    switch
    case (is[1])  
        dummy=varorder(tb,te,t,di,diff,typ,ytt,outp) 
        break
    case (is[2]) 
        dummy = createdisplay(ord+1,1)
        str=string("  %5.2f",b2[,1])+string(" (%5.2f)",sfb2[,1])
        str="  Intercept  (standard errors in parentheses)"|" "|str
        show(dummy,1,1,str)
        if (outp==1)
            " Full VAR Coefficients (standard errors)"
            str
        endif
        j=1
        while(j<=ord)
        str=string("  %5.2f",b2[,(j-1)*di+2])+string(" (%5.2f)",sfb2[,(j-1)*di+2])
        i=3
    while(i<=di+1)
        str=str+(string("  %5.2f",b2[,(j-1)*di+i]))
        str=str+(string(" (%5.2f)",sfb2[,(j-1)*di+i]))
        i=i+1
    endo
    str=string("   A%1.0f",j)|" "|str
    show(dummy,j+1,1,str)
    if (outp==1)
        " "
        str
    endif
    j=j+1
    endo break
;  
    case (is[3]) 
        dummy = createdisplay(ord+1,1)
        str=string("  %5.2f",b2[,1])+string(" (%5.2f)",b2[,1]./sfb2[,1])
        str="  Intercept  (t-ratios in parentheses)"|" "|str
        show(dummy,1,1,str)
        if (outp==1)
            " Full VAR Coefficients (t-ratios)"
            str
        endif
      j=1
      while(j<=ord)
        str=string("  %5.2f",b2[,(j-1)*di+2])+string(" (%5.2f)",b2[,(j-1)*di+2]./sfb2[,(j-1)*di+2])
        i=3
        while(i<=di+1)
          str=str+(string("  %5.2f",b2[,(j-1)*di+i]))
          str=str+(string(" (%5.2f)",b2[,(j-1)*di+i]./sfb2[,(j-1)*di+i]))
          i=i+1
        endo
        str=string("   A%1.0f",j)|" "|str
        show(dummy,j+1,1,str)
        if (outp==1)
            " "
            str
        endif
        j=j+1
    endo break
;
    case (is[4])
      dummy=createdisplay(1,1)
      str=string("%5.2e",covu[,1])
      i=2
      while(i<=di)
          str=str+string("  %5.2e",covu[,i])
          i=i+1
      endo
      str1 = "Covariance Matrix of Residuals"
      str2 = "Determinant = " + string("  %5.2f",det(covu))
      str = str1 | str2 | " " | str
      show(dummy,1,1,str)
      if (outp==1)
        "Full VAR Model"
        str
      endif
      break
    case (is[5])
      u=residuen(b,ord,di,adj,tb,te,ytt)
;
; Residual analysis   
; -----------------------------------------------------------------------------
  noquit = 1
  noback=1
  while (noquit && noback)
    head = " Menu: Residual Analysis of Full VAR estimation"
    item = " Individual Residual Series Analysis "
    item = item|" Multivariate Portmanteau statistic"
    item = item | " Multivariate normality tests"
    item = item|" Back"
    stat = selectitem(head,item,"single")'*(1:rows(item))
      
    switch
    case (stat==1)
    head = " Select time series "
    item = string(" ",1:di)+header.name+string("                ",1:di)
    item = substr(item,1,16)
    logstr = string("   ",1:di)
    item = item |" Back"
    tseries = selectitem(head,item,"single")'*(1:rows(item))
    if (tseries==0||tseries==rows(item))
      noquit = 0
      noback = 0
    endif
    while (noback)
    head = " Select desired transformation "
    item = " Residuals" | " Absolute residuals" | " Squared residuals" | " Back"
    tr = selectitem(head,item,"single")'*(1:rows(item))
    switch
    case (tr==1)
        r = u'
        item2= " residuals" break
    case (tr==2)
        r = abs(u)'
        item2= " absolute residuals" break
    case (tr==3)
        r = (u.^2)'
        item2= " squared residuals"  break
    case (tr==0 || tr == rows(item))
        noback=0
        break
    endsw
    while (noback)
      head = header.name[tseries]
      item = (" Plot of"+item2)|(" ACF of"+item2)
      item = item|(" PACF of"+item2)
      item = item|(" Periodogram of"+item2)
      item = item|" Spectral density estimation"
      item = item|" Back to results menu"
      resid = selectitem(head,item,"single")
      switch
        case (resid[1])
        header[tseries]
          dummy=timeplot(r[,tseries],400,header)
        case (resid[2])
          dummy=acfplot(r[,tseries])
          if (outp==1)
              "ACF of"+item2+" of "+head
              acf(r[,tseries]) 
          endif
        case (resid[3])
          dummy=pacfplot(r[,tseries])
          if (outp==1)
              "PACF of"+item2+" of "+head
              pacf(r[,tseries],30) 
          endif
        case (resid[4])
          pg = pgram(r[,tseries])
          if (outp==1)
              "Periodogram of"+item2+" of "+head
              pg 
          endif
        case (resid[5]) 
          sp = spec(r[,tseries])
          if (outp==1)
              "Spectral density estimate of"+item2+" of "+head
              sp 
          endif
        case (resid[6])
          noback = 0
          break    
      endsw
      endo
    endo
    dummy = 0
    dspec = 0
    dpgram = 0
    case (stat==2)      
          h=readvalue("Up to which lag should be tested?", 10)
          dummy=portmant(b,0,tb,te,t,di,ord,adj,h,di*di*(h-ord),typ,ytt,outp)
    case (stat==3)      
          dummy=normalt(t,di,ord,covu,u,outp)
    case (stat==4)
          noback=0
          break
    endsw
    endo
;
;  structural break
;  ----------------------------------------------------------------------
  case (is[6])
    dummy=strucbru(b,0,di,ord,adj,tb,te,t,covu,typ,ytt,outp)
;
;  impulse response analysis
;  -----------------------------------------------------------------------
  case(is[7])
    ira(ytt,ord,adj,header.name) 
;
;  Forecasting
;  -----------------------------------------------------------------------
    case(is[8])
     if (sum(header.diff)>0)
          head="Forecasting..."
          item="variables"
          item=item|"undifferenced variables"   
          choice=selectitem(head,item,"single")
      if (choice[1]==1)
       forecast(b,0,covu,ord,adj,tb,te,ytt,typ,header,outp)
      else 
       forec2(b,0,covu,ord,adj,tb,te,y,ytt,typ,infotran,header,outp)
      endif
     else
      forecast(b,0,covu,ord,adj,tb,te,ytt,typ,header,outp)
     endif
    break
  endsw
  until (is[rows(is)])
  noquit=0
dummy=0
endif
  
endp;
