proc (gamma, mu, sigma) = momentgp (x, k)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      pickandsgp mlegp mlegp0 hillgp1 dpgp momentgpdiag
; -----------------------------------------------------------------
;   Macro         momentgp
; -----------------------------------------------------------------
;   Description   Moment estimator for GP model.
; -----------------------------------------------------------------
;   Usage         {gamma, mu, sigma} = momentgp (x, k)
;   Input
;     Parameter   x
;     Definition      vector
;     Parameter   k
;     Definition      integer, number of upper extremes
;   Output
;     Parameter   gamma
;     Definition      scalar, estimated shape parameter
;     Parameter   mu
;     Definition      scalar, estimated location parameter
;     Parameter   sigma
;     Definition      scalar, estimated scale parameter	    
; -----------------------------------------------------------------
;   Example   library("finance")
;             randomize(0)
;	            x=randx("gp",100,1)
;             m=momentgp(x,50)
;             m
; -----------------------------------------------------------------
;   Result    Contents of m.gamma
;             [1,]    1.401
;	            Contents of m.mu
;	            [1,]   0.2003 
;             Contents of m.sigma
;             [1,]  0.48101 
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  n = rows (x)
  error (n < 3, "Data set must have at least 3 elements")
  if (k > n)
    warning (k > n, "Number of exceedances is too large")
    k = n
  endif
  if (k < 3)
    warning (k < 3, "Number of exceedances is too small")
    k = 3
  endif

  gamma = 0
  mu = 0
  sigma = 0
  if (getenv ("os")=="windows")
    r = dlcall ("_momentgp", x, rows (x), k, gamma, mu, sigma)
  else
    r = dlcall ("momentgp", x, rows (x), k, gamma, mu, sigma)
  endif
  warning (r != 0, "Moment (GP) failed")
endp
