proc () = multiplot(data,t0,dt,labels)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     plotir
; -----------------------------------------------------------------
;   Macro        multiplot
; -----------------------------------------------------------------
;   Description  Plots K-dimensional time series.
; -----------------------------------------------------------------
;   Usage        multiplot(data,t0,dt,labels)   
;   Input
;     Parameter   data
;     Definition   (TxK)-matrix of K-dimensional time series            
;     Parameter   t0
;     Definition   scalar, starting point of time series. e.g. 1960.4
;                  for fourth quarter of 1960
;     Parameter   dt
;     Definition   scalar, frequency: 1=annual, 4=quarterly, 12=monthly etc.
;     Parameter   labels
;     Definition   (Kx1)-vector of strings containing the labels for each
;                  time series
; -----------------------------------------------------------------
;   Author Benkwitz 980127
; -----------------------------------------------------------------
;
  n=rows(data) ; length of time series
  k=cols(data) ; number of time series
  ; creating x-grid
  if (dt==0)
    x=1:n
  else
    x=grid(floor(t0)+(t0-floor(t0))*10/dt,1/dt,n)
  endif
  x=vec(x.*ones(1,k))
  ; creating y-grid:
  y=vec(data)
  ;;
  color=vec(grid(0,1,6).*grid(1,0,ceil(k/7)))[1:k]  ; generating line color map
  art=#(1,2,12)  ;grid(1,0,k)                                   ; generating line art map
  thick=#(1,2,2) ; grid(1,0,k)                                 ; generating line thickness map
  ;
  xmax=max(x)
  xmin=min(x)
  ymax=max(y)
  ymin=min(y)
  ylabellines=ymax-(ymax-ymin)*grid(.1,.05,k)
  xlabellines=xmin+(xmax-xmin)*#(.05,.15,.17)
  labellines=kron(grid(1,0,k),xlabellines[1:2])~kron(ylabellines,#(1,1))
  labelpoints=grid(xlabellines[3],0,k)~ylabellines
  setmaskl(labellines,reshape(1:2*k,#(2,k))',color,art[1:k],thick[1:k]) ; little funny labellines
  setmaskp(labellines,0,0,0)                                  ; suppress circles
  setmaskt(labelpoints,labels,color,3,16)                     ; write labels
  setmaskp(labelpoints,0,0,0)                                 ; suppress circles
  ;
  data=x~y                                                    ; object to be plottet
  setmaskp(data,0,0,0)                                        ; suppress any symbols
  setmaskl(data,reshape(1:n*k,#(n,k))',color,art[1:k],thick[1:k])       ; plot time series
  d=createdisplay(1,1)
  show(d,1,1,data,labellines,labelpoints)     
endp




